% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hap_collapse.R
\name{hap_collapse}
\alias{hap_collapse}
\title{Removes Duplicated Sequences from Alignment}
\usage{
hap_collapse(dna, clean = TRUE, collapseSubstrings = TRUE, verbose = TRUE)
}
\arguments{
\item{dna}{A \link[ape:DNAbin]{DNAbin} object.}

\item{clean}{logical. Whether to remove or not remove non ACTG bases from alignment.}

\item{collapseSubstrings}{logical. Whether to collapse or not collapse shorter but identical sequences.}

\item{verbose}{logical. Returns a warning if any sequence contains non ACTG bases.
See \link{clean_dna} for details.}
}
\value{
A \link[ape:DNAbin]{DNAbin} object.
}
\description{
\code{hap_collapse()} collapses haplotypes from a \link[ape:DNAbin]{DNAbin} object,
keeping unique haplotypes only.
}
\details{
\code{hap_collapse()} collapses a \link[ape:DNAbin]{DNAbin} object, keeping unique
haplotypes only. If \code{clean = TRUE}, the function will call \link{clean_dna} to remove
any non ACTG bases from alignment prior to collapsing haplotypes. If \code{clean = FALSE},
the function will treat data as it is, and will not remove any bases. If
\code{collapseSubstrings = TRUE}, the function will consider shorter but identical
sequences as the same haplotype and collapse them, returning the longest
sequence. If \code{collapseSubstrings = FALSE}, the function will consider
shorter but identical sequences as different haplotypes and will keep them.
}
\examples{

# collapse into unique haplotypes, including shorter sequences
hap_collapse(geophagus, clean = TRUE, collapseSubstrings = TRUE)

# collapse into unique haplotypes keeping shorter sequences
hap_collapse(geophagus, clean = TRUE, collapseSubstrings = FALSE)

}
\author{
Rupert A. Collins
}
