% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggestPlot.R
\name{suggestPlot}
\alias{suggestPlot}
\title{Function suggesting a default plot for a given parameter in a descriptive table}
\usage{
suggestPlot(ltest)
}
\arguments{
\item{ltest}{character vector of tests. This normally filled by \code{\link[descsuppR]{buildDescrTbl}} which in turn usually uses the \code{method} element of the test result.}
}
\value{
tibble with columns \code{plotfun} an \code{args} where
\code{plotfun} is a string with the name of the function to be called to generate the plot and
\code{args} is a list of additional (besides the data) arguments
}
\description{
The plot suggestion is based on the test that was used for that variable.
}
\details{
The default choice is taken from \code{plotDescTbl_options$plotfun_defaults} with the current associations.

If no test was performed than numeric variables are treated as if
tested via t-tests and non-numeric variables as if tested via
Fisher test.
}
\examples{
suggestPlot("Fisher's Exact Test for Count Data")

suggestPlot("foobar")
}
\author{
Dr. Andreas Leha
}
