% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{psi_ls_cpp}
\alias{psi_ls_cpp}
\title{(C++) Psi Dissimilarity Score of Two Aligned Time Series}
\usage{
psi_ls_cpp(x, y, distance = "euclidean")
}
\arguments{
\item{x}{(required, numeric matrix) of same number of columns as 'y'.}

\item{y}{(required, numeric matrix) of same number of columns as 'x'.}

\item{distance}{(optional, character string) distance name from the "names"
column of the dataset \code{distances} (see \code{distances$name}). Default: "euclidean".}
}
\value{
numeric
}
\description{
Computes the psi dissimilarity score between two time series
observed at the same times. Time series \code{y} and \code{x} with the same
number of columns and rows. NA values should be removed before using this function.
If the selected distance function is "chi" or "cosine", pairs of zeros should
be either removed or replaced with pseudo-zeros (i.e. 0.00001).
}
\seealso{
Other Rcpp_dissimilarity_analysis: 
\code{\link{psi_dtw_cpp}()},
\code{\link{psi_equation_cpp}()},
\code{\link{psi_null_dtw_cpp}()},
\code{\link{psi_null_ls_cpp}()}
}
\concept{Rcpp_dissimilarity_analysis}
