% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharp.R
\name{dose_sensitivity_mc_gen}
\alias{dose_sensitivity_mc_gen}
\title{Sharp null monte-carlo sensitivity analysis for continuous exposures
and binary outcomes.}
\usage{
dose_sensitivity_mc_gen(
  Z,
  Q,
  index,
  mc,
  gamma,
  weights = NA,
  obsT = NULL,
  trans = identity,
  direct = "upper",
  seed = 1,
  verbose = FALSE
)
}
\arguments{
\item{Z}{A length N vector of (nonnegative) observed doses.}

\item{Q}{A length N vector of observed binary outcomes.}

\item{index}{A length N vector of indices indicating matched set membership.}

\item{mc}{An integer for the total number of Monte-Carlo samples desired.}

\item{gamma}{The nonnegative sensitivity parameter; gamma = 0 means no
unmeasured confounding.}

\item{weights}{Weights for each stratum to apply for the test statistic}

\item{obsT}{The observed value of the test statistic; default is NULL}

\item{trans}{The transformation of the doses to use for the test statistic.
Default is the identity function.}

\item{direct}{The direction of the test - "upper" or "lower"; default is upper.}

\item{seed}{seed for random number generation.}

\item{verbose}{Whether to print status updates or not; default is FALSE.}
}
\value{
A list containing two objects:

\item{mc}{A length mc vector containing the monte-carlo samples of the test
statistic.}
\item{p}{The monte-carlo p-value.}
}
\description{
Sharp null monte-carlo sensitivity analysis for continuous exposures
and binary outcomes.
}
\examples{
# Load the data
data <- lead_crime
# Make a threshold at log(3.5) transformation function.
above = function(Z) { return(Z > log(3.5)) }
# Conduct randomization test.
solution <- dose_sensitivity_mc_gen(data$log_lead, data$complain, data$matched_sets,
mc = 250, gamma = 0, trans = above)

}
