#-------------------------------------------------------------------------------
# Copyright (c) 2019-2022 University of Newcastle upon Tyne. All rights reserved.
# Copyright (c) 2022-2025 Arjuna Technologies, Newcastle upon Tyne. All rights reserved.
#
# This program and the accompanying materials
# are made available under the terms of the GNU Public License v3.0.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#-------------------------------------------------------------------------------

#
# Set up
#

# context("ds.glmPredict::smk::binomial::setup")

connect.studies.dataset.cnsim(list("LAB_TSC", "LAB_TRIG", "DIS_AMI", "DIS_DIAB", "GENDER"))

test_that("setup", {
  ds_expect_variables(c("D"))
})

#
# Tests
#

# context("ds.glmPredict::smk::binomial::without_newobj")
test_that("simple glmPredict, binomial, without newobj, se.fit=FALSE",{
  glmSLMA.res <- ds.glmSLMA('D$DIS_DIAB~D$LAB_TRIG', family="binomial", newobj="binomial.glmslma.obj")
  
  expect_length(glmSLMA.res, 9)
  expect_equal(glmSLMA.res$num.valid.studies, 3)
  expect_length(glmSLMA.res$validity.check, 1)
  expect_equal(glmSLMA.res$validity.check, "<binomial.glmslma.obj> appears valid in all sources")
  
  res <- ds.glmPredict("binomial.glmslma.obj", newdataname = NULL, output.type = "response", se.fit = FALSE, na.action = "na.pass")

  expect_length(res, 3)
  expect_equal(class(res), "list")
  
  expect_length(res$sim1, 1)
  expect_length(res$sim1$safe.list, 10)
  expect_equal(class(res$sim1$safe.list), "list")
  expect_equal(res$sim1$safe.list$glm.object, "binomial.glmslma.obj")
  expect_true(is.null(res$sim1$safe.list$newdfname))
  expect_equal(res$sim1$safe.list$output.type, "response")
  expect_true(is.null(res$sim1$safe.list$dispersion))
  expect_equal(res$sim1$safe.list$fit.Ntotal, 1801)
  expect_equal(res$sim1$safe.list$fit.Nvalid, 1801)
  expect_equal(res$sim1$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim1$safe.list$fit.mean, 0.01388118, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.sd, 0.1228967, tolerance = ds.test_env$tolerance)
  expect_length(res$sim1$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim1$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim1$safe.list$fit.quantiles[[1]], 0.004276445, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[2]], 0.005286237, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[3]], 0.007428756, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[4]], 0.011330492, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[5]], 0.016775371, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[6]], 0.024259416, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[7]], 0.029864696, tolerance = ds.test_env$tolerance)
  
  expect_length(res$sim2, 1)
  expect_length(res$sim2$safe.list, 10)
  expect_equal(class(res$sim2$safe.list), "list")
  expect_equal(res$sim2$safe.list$glm.object, "binomial.glmslma.obj")
  expect_true(is.null(res$sim2$safe.list$newdfname))
  expect_equal(res$sim2$safe.list$output.type, "response")
  expect_true(is.null(res$sim2$safe.list$dispersion))
  expect_equal(res$sim2$safe.list$fit.Ntotal, 2526)
  expect_equal(res$sim2$safe.list$fit.Nvalid, 2526)
  expect_equal(res$sim2$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim2$safe.list$fit.mean, 0.01306413, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.sd, 0.1058779, tolerance = ds.test_env$tolerance)
  expect_length(res$sim2$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim2$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim2$safe.list$fit.quantiles[[1]], 0.004114235, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[2]], 0.005070055, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[3]], 0.007363168, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[4]], 0.010906288, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[5]], 0.015909292, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[6]], 0.022784761, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[7]], 0.027798164, tolerance = ds.test_env$tolerance)
  
  expect_length(res$sim3, 1)
  expect_length(res$sim3$safe.list, 10)
  expect_equal(class(res$sim3$safe.list), "list")
  expect_equal(res$sim3$safe.list$glm.object, "binomial.glmslma.obj")
  expect_true(is.null(res$sim3$safe.list$newdfname))
  expect_equal(res$sim3$safe.list$output.type, "response")
  expect_true(is.null(res$sim3$safe.list$dispersion))
  expect_equal(res$sim3$safe.list$fit.Ntotal, 3473)
  expect_equal(res$sim3$safe.list$fit.Nvalid, 3473)
  expect_equal(res$sim3$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim3$safe.list$fit.mean, 0.01612439, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.sd, 0.08681195, tolerance = ds.test_env$tolerance)
  expect_length(res$sim3$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim3$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim3$safe.list$fit.quantiles[[1]], 0.007566798, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[2]], 0.008984660, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[3]], 0.011332598, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[4]], 0.014793185, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[5]], 0.019366204, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[6]], 0.024738972, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[7]], 0.029020811, tolerance = ds.test_env$tolerance)
  
})

# context("ds.glmPredict::smk::binomial::with_newobj")
test_that("simple glmPredict, binomial, with newobj, se.fit=FALSE", {
    glmSLMA.res <- ds.glmSLMA('D$DIS_DIAB~D$LAB_TRIG', family="binomial", newobj="binomial.glmslma.obj")
    
    expect_length(glmSLMA.res, 9)
    expect_equal(glmSLMA.res$num.valid.studies, 3)
    expect_length(glmSLMA.res$validity.check, 1)
    expect_equal(glmSLMA.res$validity.check, "<binomial.glmslma.obj> appears valid in all sources")
    
    res <- ds.glmPredict("binomial.glmslma.obj", output.type = "response", se.fit = FALSE, newobj="binomial.glm.predict.obj")
    
    expect_length(res, 3)
    expect_equal(class(res), "list")
    
    expect_length(res$sim1, 1)
    expect_length(res$sim1$safe.list, 10)
    expect_equal(class(res$sim1$safe.list), "list")
    expect_equal(res$sim1$safe.list$glm.object, "binomial.glmslma.obj")
    expect_true(is.null(res$sim1$safe.list$newdfname))
    expect_equal(res$sim1$safe.list$output.type, "response")
    expect_true(is.null(res$sim1$safe.list$dispersion))
    expect_equal(res$sim1$safe.list$fit.Ntotal, 1801)
    expect_equal(res$sim1$safe.list$fit.Nvalid, 1801)
    expect_equal(res$sim1$safe.list$fit.Nmiss, 0)
    expect_equal(res$sim1$safe.list$fit.mean, 0.01388118, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim1$safe.list$fit.sd, 0.1228967, tolerance = ds.test_env$tolerance)
    expect_length(res$sim1$safe.list$fit.quantiles, 7)
    expect_equal(class(res$sim1$safe.list$fit.quantiles), "numeric")
    expect_equal(res$sim1$safe.list$fit.quantiles[[1]], 0.004276445, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim1$safe.list$fit.quantiles[[2]], 0.005286237, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim1$safe.list$fit.quantiles[[3]], 0.007428756, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim1$safe.list$fit.quantiles[[4]], 0.011330492, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim1$safe.list$fit.quantiles[[5]], 0.016775371, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim1$safe.list$fit.quantiles[[6]], 0.024259416, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim1$safe.list$fit.quantiles[[7]], 0.029864696, tolerance = ds.test_env$tolerance)

    expect_length(res$sim2, 1)
    expect_length(res$sim2$safe.list, 10)
    expect_equal(class(res$sim2$safe.list), "list")
    expect_equal(res$sim2$safe.list$glm.object, "binomial.glmslma.obj")
    expect_true(is.null(res$sim2$safe.list$newdfname))
    expect_equal(res$sim2$safe.list$output.type, "response")
    expect_true(is.null(res$sim2$safe.list$dispersion))
    expect_equal(res$sim2$safe.list$fit.Ntotal, 2526)
    expect_equal(res$sim2$safe.list$fit.Nvalid, 2526)
    expect_equal(res$sim2$safe.list$fit.Nmiss, 0)
    expect_equal(res$sim2$safe.list$fit.mean, 0.01306413, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim2$safe.list$fit.sd, 0.1058779, tolerance = ds.test_env$tolerance)
    expect_length(res$sim2$safe.list$fit.quantiles, 7)
    expect_equal(class(res$sim2$safe.list$fit.quantiles), "numeric")
    expect_equal(res$sim2$safe.list$fit.quantiles[[1]], 0.004114235, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim2$safe.list$fit.quantiles[[2]], 0.005070055, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim2$safe.list$fit.quantiles[[3]], 0.007363168, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim2$safe.list$fit.quantiles[[4]], 0.010906288, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim2$safe.list$fit.quantiles[[5]], 0.015909292, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim2$safe.list$fit.quantiles[[6]], 0.022784761, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim2$safe.list$fit.quantiles[[7]], 0.027798164, tolerance = ds.test_env$tolerance)

    expect_length(res$sim3, 1)
    expect_length(res$sim3$safe.list, 10)
    expect_equal(class(res$sim3$safe.list), "list")
    expect_equal(res$sim3$safe.list$glm.object, "binomial.glmslma.obj")
    expect_true(is.null(res$sim3$safe.list$newdfname))
    expect_equal(res$sim3$safe.list$output.type, "response")
    expect_true(is.null(res$sim3$safe.list$dispersion))
    expect_equal(res$sim3$safe.list$fit.Ntotal, 3473)
    expect_equal(res$sim3$safe.list$fit.Nvalid, 3473)
    expect_equal(res$sim3$safe.list$fit.Nmiss, 0)
    expect_equal(res$sim3$safe.list$fit.mean, 0.01612439, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim3$safe.list$fit.sd, 0.08681195, tolerance = ds.test_env$tolerance)
    expect_length(res$sim3$safe.list$fit.quantiles, 7)
    expect_equal(class(res$sim3$safe.list$fit.quantiles), "numeric")
    expect_equal(res$sim3$safe.list$fit.quantiles[[1]], 0.007566798, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim3$safe.list$fit.quantiles[[2]], 0.008984660, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim3$safe.list$fit.quantiles[[3]], 0.011332598, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim3$safe.list$fit.quantiles[[4]], 0.014793185, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim3$safe.list$fit.quantiles[[5]], 0.019366204, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim3$safe.list$fit.quantiles[[6]], 0.024738972, tolerance = ds.test_env$tolerance)
    expect_equal(res$sim3$safe.list$fit.quantiles[[7]], 0.029020811, tolerance = ds.test_env$tolerance)
})

# context("ds.glmPredict::smk::binomial::sefit_true")
test_that("simple glmPredict, binomial, with newobj, se.fit=TRUE", {
  glmSLMA.res <- ds.glmSLMA('D$DIS_DIAB~D$LAB_TRIG', family="binomial", newobj="binomial.glmslma.obj")
  
  expect_length(glmSLMA.res, 9)
  expect_equal(glmSLMA.res$num.valid.studies, 3)
  expect_length(glmSLMA.res$validity.check, 1)
  expect_equal(glmSLMA.res$validity.check, "<binomial.glmslma.obj> appears valid in all sources")
  
  res <- ds.glmPredict("binomial.glmslma.obj", newdataname = NULL, output.type = "response", se.fit = TRUE, na.action = "na.pass", newobj="binomial.glm.predict.sefit.obj")
  
  expect_length(res, 3)
  expect_equal(class(res), "list")

  expect_length(res$sim1, 1)
  expect_length(res$sim1$safe.list, 17)
  expect_equal(class(res$sim1$safe.list), "list")
  expect_equal(res$sim1$safe.list$glm.object, "binomial.glmslma.obj")
  expect_true(is.null(res$sim1$safe.list$newdfname))
  expect_equal(res$sim1$safe.list$output.type, "response")
  expect_true(is.null(res$sim1$safe.list$dispersion))
  expect_equal(res$sim1$safe.list$fit.Ntotal, 1801)
  expect_equal(res$sim1$safe.list$fit.Nvalid, 1801)
  expect_equal(res$sim1$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim1$safe.list$fit.mean, 0.01388118, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.sd, 0.01510361, tolerance = ds.test_env$tolerance)
  expect_length(res$sim1$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim1$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim1$safe.list$fit.quantiles[[1]], 0.004276445, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[2]], 0.005286237, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[3]], 0.007428756, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[4]], 0.011330492, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[5]], 0.016775371, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[6]], 0.024259416, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[7]], 0.029864696, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.Ntotal, 1801)
  expect_equal(res$sim1$safe.list$se.fit.Nvalid, 1801)
  expect_equal(res$sim1$safe.list$se.fit.Nmiss, 0)
  expect_equal(res$sim1$safe.list$se.fit.mean, 0.003569239, tolerance = 1e-8)
  expect_equal(res$sim1$safe.list$se.fit.sd, 0.00768495, tolerance = 1e-8)
  expect_length(res$sim1$safe.list$se.fit.quantiles, 7)
  expect_equal(class(res$sim1$safe.list$se.fit.quantiles), "numeric")
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[1]], 0.001747688, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[2]], 0.001918347, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[3]], 0.002191026, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[4]], 0.002585741, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[5]], 0.003353623, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[6]], 0.005213378, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[7]], 0.007129711, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$residual.scale, 1, tolerance = ds.test_env$tolerance)
  
  expect_length(res$sim2, 1)
  expect_length(res$sim2$safe.list, 17)
  expect_equal(class(res$sim2$safe.list), "list")
  expect_equal(res$sim2$safe.list$glm.object, "binomial.glmslma.obj")
  expect_true(is.null(res$sim2$safe.list$newdfname))
  expect_equal(res$sim2$safe.list$output.type, "response")
  expect_true(is.null(res$sim2$safe.list$dispersion))
  expect_equal(res$sim2$safe.list$fit.Ntotal, 2526)
  expect_equal(res$sim2$safe.list$fit.Nvalid, 2526)
  expect_equal(res$sim2$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim2$safe.list$fit.mean, 0.01306413, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.sd, 0.01121012, tolerance = ds.test_env$tolerance)
  expect_length(res$sim2$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim2$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim2$safe.list$fit.quantiles[[1]], 0.004114235, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[2]], 0.005070055, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[3]], 0.007363168, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[4]], 0.010906288, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[5]], 0.015909292, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[6]], 0.022784761, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[7]], 0.027798164, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.Ntotal, 2526)
  expect_equal(res$sim2$safe.list$se.fit.Nvalid, 2526)
  expect_equal(res$sim2$safe.list$se.fit.Nmiss, 0)
  expect_equal(res$sim2$safe.list$se.fit.mean, 0.002968172, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.sd, 0.005111322, tolerance = ds.test_env$tolerance)
  expect_length(res$sim2$safe.list$se.fit.quantiles, 7)
  expect_equal(class(res$sim2$safe.list$se.fit.quantiles), "numeric")
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[1]], 0.001572552, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[2]], 0.001704822, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[3]], 0.001917358, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[4]], 0.002159206, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[5]], 0.002756816, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[6]], 0.004427053, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[7]], 0.006137771, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$residual.scale, 1, tolerance = ds.test_env$tolerance)

  expect_length(res$sim3, 1)
  expect_length(res$sim3$safe.list, 17)
  expect_equal(class(res$sim3$safe.list), "list")
  expect_equal(res$sim3$safe.list$glm.object, "binomial.glmslma.obj")
  expect_true(is.null(res$sim3$safe.list$newdfname))
  expect_equal(res$sim3$safe.list$output.type, "response")
  expect_true(is.null(res$sim3$safe.list$dispersion))
  expect_equal(res$sim3$safe.list$fit.Ntotal, 3473)
  expect_equal(res$sim3$safe.list$fit.Nvalid, 3473)
  expect_equal(res$sim3$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim3$safe.list$fit.mean, 0.01612439, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.sd, 0.007536315, tolerance = ds.test_env$tolerance)
  expect_length(res$sim3$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim3$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim3$safe.list$fit.quantiles[[1]], 0.007566798, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[2]], 0.008984660, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[3]], 0.011332598, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[4]], 0.014793185, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[5]], 0.019366204, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[6]], 0.024738972, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[7]], 0.029020811, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.Ntotal, 3473)
  expect_equal(res$sim3$safe.list$se.fit.Nvalid, 3473)
  expect_equal(res$sim3$safe.list$se.fit.Nmiss, 0)
  expect_equal(res$sim3$safe.list$se.fit.mean, 0.002848933, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.sd, 0.002740361, tolerance = ds.test_env$tolerance)
  expect_length(res$sim3$safe.list$se.fit.quantiles, 7)
  expect_equal(class(res$sim3$safe.list$se.fit.quantiles), "numeric")
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[1]], 0.002102462, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[2]], 0.002106133, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[3]], 0.002132488, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[4]], 0.002197552, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[5]], 0.002626926, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[6]], 0.004153282, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[7]], 0.005834279, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$residual.scale, 1, tolerance = ds.test_env$tolerance)
  
})  

#
# Shutdown
#

# context("ds.glmPredict::smk::binomial::shutdown")

test_that("shutdown", {
  ds_expect_variables(c("D", "binomial.glmslma.obj", "binomial.glm.predict.obj", "binomial.glm.predict.sefit.obj", "predict_glm" ))
})

disconnect.studies.dataset.cnsim()

#
# Done
#

# context("ds.glmPredict::smk::binomial::done")
