% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWeightsByCue.R
\name{getWeightsByCue}
\alias{getWeightsByCue}
\title{Extract the change of connection weights between a specific cue and all 
outcomes.}
\usage{
getWeightsByCue(wmlist, cue, select.outcomes = NULL, init.value = 0)
}
\arguments{
\item{wmlist}{A list with weightmatrices, generated by 
\code{\link{RWlearning}} or \code{\link{updateWeights}}.}

\item{cue}{String: cue for which to extract the connection weights.}

\item{select.outcomes}{Optional selection of outcomes to limit the number of 
connection weights that are returned. The value of NULL (default) will 
return all connection weights. Note that specified values that are not in 
the weightmatrices will return the initial value without error or warning. 
Please use \code{\link{getOutcomes}} for returning all outcomes from the data, and 
\code{\link{getValues}} for returning all outcomes in the data.}

\item{init.value}{Value of connection weights for non-existing connections. 
Typically set to 0.}
}
\value{
Data frame.
}
\description{
Extract the change of connection weights between all cues and 
a specific outcome. The values are returned as data frame.
}
\examples{
# load example data:
data(dat)

# add obligatory columns Cues, Outcomes, and Frequency:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
head(dat)
dim(dat)

# now use createTrainingData to sample from the specified frequencies: 
train <- createTrainingData(dat)

# this training data can actually be used train network:
wm <- RWlearning(train)

# final weight matrix:
getWM(wm)

# Inspect the change in connection weights 
# for cue=car
cueweights <- getWeightsByCue(wm, cue='car')
head(cueweights)
emptyPlot(nrow(cueweights), c(-.5,1), h0=0,
    main="Cue='car'", ylab='connection weights', xlab='learning events')
lines(cueweights$vehicle)
lines(cueweights$plant, col='red', lty=4)
lines(cueweights$animal, col='red', lty=2)
legend_margin('topright', legend=c('animal', 'plant', 'vehicle'),
    col=c(2,2,1), lty=c(2,4,1), lwd=1, bty='n')

}
\seealso{
\code{\link{plotCueWeights}}, \code{\link{plotOutcomeWeights}}, 
\code{\link{getWeightsByOutcome}}
}
\author{
Jacolien van Rij
}
