% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotActivations.R
\name{plotActivations}
\alias{plotActivations}
\title{Visualize the change of connection weights between a specific outcome and all 
cues.}
\usage{
plotActivations(
  wmlist,
  cueset,
  split = "_",
  select.outcomes = NULL,
  init.value = 0,
  add.labels = TRUE,
  add = FALSE,
  ...
)
}
\arguments{
\item{wmlist}{A list with weightmatrices, generated by 
\code{\link{RWlearning}} or \code{\link{updateWeights}}.}

\item{cueset}{String, which contains the combination of cues for which to 
calculate the activations for per learning event.}

\item{split}{String, separator between cues.}

\item{select.outcomes}{Optional selection of outcomes to limit the number of 
activations that are returned. The value of NULL (default) will 
return all activations. Note that specified values that are not in 
the weightmatrices will return the initial value without error or warning. 
Please use  \code{\link{getValues}} for returning all outcomes in the data.}

\item{init.value}{Value of connection weights for non-existing connections. 
Typically set to 0.}

\item{add.labels}{Logical: whether or not to add labels for the lines. 
Defaults to TRUE, see examples.}

\item{add}{Logical: whether or not to add the lines to an existing plot. 
Defaults to FALSE (starting a new plot).}

\item{...}{Optional graphical arguments, as specified in 
\code{\link[graphics]{par}}. These parameters are forwarded to the functions 
\code{\link[plotfunctions]{emptyPlot}}, \code{\link[graphics]{lines}}, and 
\code{\link[graphics]{text}}.}
}
\value{
Optionally a list with label specifications is returned, which 
allows to plot your own labels. This may be helpful for very long labels, 
and for overlapping lines.
}
\description{
Visualize the activation or the change of activation per 
event.
}
\examples{
# load example data:
data(dat)

# add obligatory columns Cues, Outcomes, and Frequency:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
# now use createTrainingData to sample from the specified frequencies: 
train <- createTrainingData(dat)

# this training data can be used train network:
wm <- RWlearning(train)

# plot connection weights for cue = 'cat':
plotActivations(wm, cueset="BG_cat_brown")
plotActivations(wm, cueset="BG_cat")

# plot your own labels:
labels <- plotActivations(wm, cues="BG_cat", add.labels=FALSE)
legend_margin('topright', legend=labels$labels, col=labels$col, 
    lwd=1, bty='n')

# change color and select outcomes:
out <- getValues(train$Outcomes, unique=TRUE)
out <- out[! out \%in\% "animal"]
labels <- plotActivations(wm, cues="BG_cat", 
    select.outcome=out, add.labels=FALSE, 
	   ylim=c(-.25,1),col=alpha(1))
lab2 <- plotActivations(wm, cues="BG_cat", add.labels=FALSE, 
    select.outcomes="animal", add=TRUE, col=2, lwd=2, xpd=TRUE)
legend('topright', legend=c("animal", labels$labels), 
    col=c(lab2$col, labels$col), lwd=c(lab2$lwd, labels$lwd), 
    lty=c(lab2$lty, labels$lty), bty="n")

}
\seealso{
\code{\link{plotCueWeights}}, \code{\link{getWeightsByOutcome}}, 
\code{\link{getWeightsByCue}}
}
\author{
Jacolien van Rij
}
