% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lead_processing.R
\name{process_lead_cohort_data}
\alias{process_lead_cohort_data}
\title{Process raw LEAD data into analysis-ready format with energy metrics}
\usage{
process_lead_cohort_data(data, dataset, vintage, aggregate_poverty = FALSE)
}
\arguments{
\item{data}{A data frame of raw LEAD data from OpenEI}

\item{dataset}{Character string indicating dataset type ("ami" or "fpl")}

\item{vintage}{Character string indicating ACS vintage year}

\item{aggregate_poverty}{Logical; if TRUE, aggregate to poverty status level}
}
\value{
A data frame ready for analysis with all energy metrics
}
\description{
This is the main processing workflow that:
\enumerate{
\item Converts raw OpenEI data to clean format
\item Optionally aggregates by poverty status
\item Adds energy burden and related metrics
\item Filters out zero-energy records
}
}
\keyword{internal}
