% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic.media.R
\name{ic.media}
\alias{ic.media}
\title{Intervalo confianza para la media.}
\usage{
ic.media(
  x,
  variable = NULL,
  introducir = FALSE,
  poblacion = c("normal", "desconocida"),
  var_pob = c("conocida", "desconocida"),
  confianza = 0.95,
  grafico = FALSE
)
}
\arguments{
\item{x}{Conjunto de datos. Puede ser un vector o un dataframe.}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de \code{x}. Si \code{x} se refiere una sola variable, \code{variable = NULL}. En caso contrario, es necesario indicar el nombre o posición (número de columna) de la variable.}

\item{introducir}{Valor lógico. Si \code{introducir = FALSE} (por defecto), el usuario debe indicar el conjunto de datos que desea analizar usando los argumentos \code{x} y/o \code{variable}. Si \code{introducir = TRUE}, se le solicitará al ususario que introduzca la información relevante sobre tamaño muestral, valor de la media muestral, etc.}

\item{poblacion}{Es un carácter. Indica la distribución de probabilidad de la población. Por defecto \code{poblacion = "normal"}. Si la distribución de la población es desconocida, cambiar a \code{poblacion = "desconocida"}.}

\item{var_pob}{Es un carácter. Indica si la varianza poblacional es conocida (por defecto, \code{var_pob = "conocida"}) o desconocida. En este último caso debería cambiarse el argumento a \code{var_pob = "desconocida"}.}

\item{confianza}{Es un valor numérico entre 0 y 1. Indica el nivel de confianza. Por defecto, \code{confianza = 0.95} (95 por ciento)}

\item{grafico}{Es un valor lógico. Por defecto \code{grafico = FALSE}. Si se quiere obtener una representación gráfica del intervalo de confianza obtenido, cambiar el argumento a \code{grafico = TRUE}. Nota: Esta opción no está implementada para todos los casos.}
}
\value{
Devuelve el intervalo de confianza de la media poblacional en un objeto de tipo \code{data.frame}. Si \code{grafico = T} devuelve una \code{list} con el intervalo de confianza y su representación gráfica.
}
\description{
Calcula el intervalo de confianza de la media poblacional.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qricmedia.png}{width = 200px}}
\if{latex}{\figure{qricmedia.png}{options: width=3cm}}
}
\details{
(1) Si población desconocida, varianza poblacial conocida y muestra pequeña:

\if{html}{\figure{icmediadesconocidavarcon.png}{width = 400px}}
\if{latex}{\figure{icmediadesconocidavarcon.png}{options: width=10cm}}

(2) Si población normal, varianza poblacional conocida (muestra pequeña y grande)

\if{html}{\figure{icmediavarcon.png}{width = 440px}}
\if{latex}{\figure{icmediavarcon.png}{options: width=10cm}}

(3) Si población normal, varianza poblacional desconocida y muestra pequeña

Con la varianza muestral:

\if{html}{\figure{icmediavardescmuestral.png}{width = 400px}}
\if{latex}{\figure{icmediavardescmuestral.png}{options: width=10cm}}

Con la cuasivarianza muestral:

\if{html}{\figure{icmediavardesccuasi.png}{width = 400px}}
\if{latex}{\figure{icmediavardesccuasi.png}{options: width=10cm}}

Nota: En ambos casos, el valor crítico sigue una distribución t con n-1 grados de libertad

(4) Si población normal, varianza poblacional desconocida y muestra grande:
Puede utilizarse la aproximación a la normal. El intervalo se obtiene a partir de la expresión (2)
estimando la varianza poblacional por la varianza (o cuasivarianza) muestral.
}
\references{
Casas José M. (1997) Inferencia estadística. Editorial: Centro de estudios Ramón Areces, S.A. ISBN: 848004263-X

Esteban García, J. et al. (2008). Curso básico de inferencia estadística. ReproExprés, SL. ISBN: 8493036595.

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
