% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pbiserial_rest}
\alias{pbiserial_rest}
\title{Point-biserial correlation for item analysis}
\usage{
pbiserial_rest(item, rest)
}
\arguments{
\item{item}{A numeric vector of dichotomous item scores (0/1).}

\item{rest}{A numeric vector of the total scores, excluding the item.}
}
\value{
The point-biserial correlation coefficient.
}
\description{
Calculates the correlation between a single item's score and the
rest of the total score.
}
\examples{
item1 <- c(1, 0, 1, 0, 1, 1)
rest_score <- c(10, 8, 12, 5, 9, 11)
pbiserial_rest(item1, rest_score)
}
