% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-bin.R
\name{bin}
\alias{bin}
\title{Bin pupil time series by averaging within time bins}
\usage{
bin(eyeris, bins_per_second, method = "mean", call_info = NULL)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} derived from \code{\link[=load_asc]{load_asc()}}}

\item{bins_per_second}{The number of bins to create per second of data}

\item{method}{The binning method: "mean" (default) or "median"}

\item{call_info}{A list of call information and parameters. If not provided,
it will be generated from the function call. Defaults to \code{NULL}}
}
\value{
An \code{eyeris} object with binned data and updated sampling rate
}
\description{
This function bins pupillometry data by dividing time into equal intervals
and averaging the data within each bin. Unlike downsampling, binning
averages data points within each time bin.
}
\details{
Binning divides one second of pupillary data into X bins and averages
pupillometry data around each bin center. The resulting time points will be:
1/2X, 3/2X, 5/2X, ..., etc. where X is the number of bins per second.

This approach is commonly used in pupillometry research to study temporal
dynamics of pupil dilatory response; however, it should be used with caution
(as averaging within bins can distort the pupillary dynamics).
}
\note{
This function is part of the \code{glassbox()} preprocessing pipeline and is not
intended for direct use in most cases. Provide parameters via
\code{bin = list(...)}.

Advanced users may call it directly if needed.
}
\examples{
demo_data <- eyelink_asc_demo_dataset()

# bin data into 10 bins per second using the (default) "mean" method
demo_data |>
  eyeris::glassbox(bin = list(bins_per_second = 10, method = "mean")) |>
  plot(seed = 0)

}
\seealso{
\code{\link[=glassbox]{glassbox()}} for the recommended way to run this step as
part of the full eyeris glassbox preprocessing pipeline
\code{\link[=downsample]{downsample()}} for downsampling functionality
}
