% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{norm2pois}
\alias{norm2pois}
\title{Convert normal to poisson}
\usage{
norm2pois(x, lambda, mu = mean(x), sd = stats::sd(x))
}
\arguments{
\item{x}{the normally distributed vector}

\item{lambda}{the mean of the distribution to return}

\item{mu}{the mean of x (calculated from x if not given)}

\item{sd}{the SD of x (calculated from x if not given)}
}
\value{
a vector with a poisson distribution
}
\description{
Convert normal to poisson
}
\examples{

x <- rnorm(10000)
y <- norm2pois(x, 2)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
