% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{felt_create_map}
\alias{felt_create_map}
\title{Create a new map}
\usage{
felt_create_map(
  title = NULL,
  basemap = NULL,
  layer_urls = NULL,
  lat = NULL,
  lon = NULL,
  zoom = NULL,
  description = NULL,
  public_access = NULL,
  clean = TRUE
)
}
\arguments{
\item{title}{Title to use for the map. Defaults to \code{NULL}.}

\item{basemap}{Basemap for the new map. Defaults to \code{NULL}. Can be a URL or color hex code.
Text options include \code{'default'} (same as \code{NULL}), \code{'light'}, \code{'dark'}, or \code{'satellite'}.}

\item{layer_urls}{vector of URLs to generate layers in map. Defaults to \code{NULL}.}

\item{lat}{latitude to center the map. Defaults to \code{NULL}.}

\item{lon}{longitude to center the map. Defaults to \code{NULL}}

\item{zoom}{zoom level to initialize the map with. Defaults to \code{NULL}.}

\item{description}{Description for the map legend. Defaults to \code{NULL}.}

\item{public_access}{Degree of public acess. Defaults to \code{NULL}, which is \code{view_only}.
Text options also include \code{'private'}, \code{'view_and_comment'}, and \code{'view_comment_and_edit'}.}

\item{clean}{logical, whether to turn the API response into a \link[tibble:tibble]{tibble::tibble}}
}
\value{
a \link[tibble:tibble]{tibble::tibble} for the new map
}
\description{
Create a new map
}
\examples{
\dontshow{if (has_felt_key()) withAutoprint(\{ # examplesIf}
map <- felt_create_map(title = 'feltr example')
map
# and delete it again
felt_delete_map(map_id = map$id)
\dontshow{\}) # examplesIf}
}
\concept{map}
