% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13_inverse_predict.R
\name{inverse_predict.modeler}
\alias{inverse_predict.modeler}
\title{Inverse prediction from a \code{modeler} object}
\usage{
\method{inverse_predict}{modeler}(
  object,
  y,
  id = NULL,
  interval = NULL,
  tol = 1e-06,
  resolution = 1000,
  ...
)
}
\arguments{
\item{object}{A fitted object of class \code{modeler}.}

\item{y}{A numeric scalar giving the target y-value for which to compute the corresponding x.}

\item{id}{Optional vector of \code{uid}s for which to perform inverse prediction. If \code{NULL}, all groups are used.}

\item{interval}{Optional numeric vector of length 2 specifying the interval in which to search for the root.
If \code{NULL}, the interval is inferred from the range of the observed x-values.}

\item{tol}{Numerical tolerance passed to \code{\link[stats]{uniroot}} for root-finding accuracy.}

\item{resolution}{Integer. Number of grid points used to scan the interval.}

\item{...}{Additional parameters for future functionality.}
}
\value{
A \code{tibble} with one row per group, containing:
\itemize{
  \item \code{uid} – unique identifier of the group,
  \item \code{fn_name} – the name of the fitted function,
  \item \code{lower} and \code{upper} – the search interval used,
  \item \code{y} – the predicted y-value (from the function at the root),
  \item \code{x} – the x-value at which the function reaches \code{y}.
}
}
\description{
Computes the x-value at which a fitted model reaches a user-specified response value (y-value).
}
\details{
The function uses numeric root-finding to solve \code{f(t, ...params) = y}.
If no root is found in the interval, \code{NA} is returned.
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin_plat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(15, 2, 45)
  )
print(mod_1)
inverse_predict(mod_1, y = 50)
inverse_predict(mod_1, y = 75, interval = c(20, 80))
}
\seealso{
\code{\link{predict.modeler}}, \code{\link[stats]{uniroot}}
}
