% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_readme.R
\name{write_readme}
\alias{write_readme}
\title{Create a Project README File}
\usage{
write_readme(path = here::here())
}
\arguments{
\item{path}{Character. Path to the project directory. Default is current project
root via \code{\link[here]{here}}.}
}
\value{
Invisibly returns the path to the created file.
}
\description{
This function streamlines project documentation by creating a \code{README.md} file
and opening it for editing.
}
\details{
The \code{README.md} template includes structured sections for:
\itemize{
  \item Project description (study name, principal investigator, author)
  \item Project setup steps for reproducibility
  \item File and directory descriptions
  \item Miscellaneous project notes
}
}
\examples{
# Create a temporary directory for testing
tmp_dir <- tempdir()

# Write the README file
write_readme(path = tmp_dir)

# Confirm the file was created
file.exists(file.path(tmp_dir, "README.md"))

# Clean up
unlink(file.path(tmp_dir, "README.md"))

}
\seealso{
\code{\link{quarto_project}}, \code{\link{write_notes}}
}
