% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmfcc.R
\name{RoAMFEWMA_PhaseI}
\alias{RoAMFEWMA_PhaseI}
\title{Robust Adaptive Multivariate Functional EWMA Control Chart - Phase I}
\usage{
RoAMFEWMA_PhaseI(
  mfdobj,
  mfdobj_tuning,
  functional_filter_par = list(filter = TRUE),
  imputation_par = list(method_imputation = "RoMFDI", n_dataset = 1),
  verbose = FALSE
)
}
\arguments{
\item{mfdobj}{A multivariate functional data object of class \code{mfd}.
This dataset is used as the Phase I \strong{training set}.
A functional filter is first applied to detect functional cellwise
outliers; the flagged components are then imputed through a robust
multivariate functional imputation procedure.
The imputed data are subsequently processed by the Robust Multivariate
Functional Control Chart to detect and remove
functional casewise outliers.
The resulting clean dataset (free of both cellwise and casewise outliers)
is then used as the training set in the Phase I of the Adaptive
Multivariate Functional EWMA control chart.}

\item{mfdobj_tuning}{A multivariate functional data object of class \code{mfd}
representing the Phase I \strong{tuning set}.
This dataset undergoes the same functional filtering and robust
imputation steps applied to \code{mfdobj}.
The filtered and imputed data are used within the Robust Multivariate
Functional Control Chart to estimate tuning quantities and control limits.
After casewise cleaning, the resulting clean tuning set is employed in the
Phase I calibration of the Adaptive Multivariate Functional EWMA control chart.}

\item{functional_filter_par}{A list with an argument \code{filter} that can be TRUE or FALSE depending
on if the functional filter step must be performed or not.
All the other arguments of this list are passed as arguments to the function
\code{functional_filter} in the filtering step.
All the arguments that are not passed take their default values.
See \code{\link{functional_filter}} for all the arguments and their default
values.
Default is \code{list(filter = TRUE)}.}

\item{imputation_par}{A list with an argument \code{method_imputation}
that can be \code{"RoMFDI"} or \code{"mean"} depending
on if the imputation step must be done by means of \code{\link{RoMFDI}} or
by just using the mean of each functional variable.
If \code{method_imputation = "RoMFDI"},
all the other arguments of this list are passed as arguments to the function
\code{RoMFDI} in the imputation step.
All the arguments that are not passed take their default values.
See \code{\link{RoMFDI}} for all the arguments and their default
values.
Default value is \code{list(method_imputation = "RoMFDI")}.}

\item{verbose}{If TRUE, it prints messages about the steps of the algorithm.
Default is FALSE.}
}
\value{
A list of the following elements:
\itemize{
\item \code{mod_1} object returned by \code{AMFEWMA_PhaseI}, see the value
of \code{\link{AMFEWMA_PhaseI}} for a full description of its component;
\item \code{mfd_clean_training} training data after complete cleaning,
containing no outliers at either cellwise or casewise;
\item \code{mfd_clean_tuning} tuning data after complete cleaning,
containing no outliers at either cellwise or casewise;
\item \code{mfd_all_clean} full Phase I clean data (training + tuning);
\item \code{idx_casewise_outliers} indices of observations indetified as
casewise outliers by RoMFCC Phase II;
\item \code{ff_training} training set after the functional filter;
\item \code{ff_tuning} tuning set after the functional filter;
\item \code{X_imp_training_1} first imputation of the training set
after RoMFDI
\item \code{X_imp_tuning_1} first imputation of the tuning set
after RoMFDI
\item \code{X_all_imputed} training + tuning data after robust multivariate
functional imputation;
\item \code{mod_RoMFCC_phaseI_casewise} object returned by RoMFCC_PhaseI,
see the value of \code{\link{RoMFCC_PhaseI_casewise}} for a full description
of its component;
\item \code{mod_RoMFCC_phaseII_casewise} object returned by RoMFCC_PhaseII,
see the value of \code{\link{RoMFCC_PhaseII_casewise}} for a full
description of its component;
}
}
\description{
It performs Phase I of the Robust Adaptive Multivariate
Functional EWMA control chart (RoAMFEWMA).
The procedure combines:
\enumerate{
\item Functional cellwise outlier detection via
\code{\link{functional_filter}},
\item Robust Multivariate Functional Data Imputation (RoMFDI) via
\code{\link{RoMFDI}},
\item Casewise outliers detection via RoMFCC
(\code{\link{RoMFCC_PhaseI_casewise}} and
\code{\link{RoMFCC_PhaseII_casewise}}),
on the imputed Phase I data,
\item AMFEWMA Phase I calibration (\code{\link{AMFEWMA_PhaseI}})
on cellwise and casewise clean data.
}
The resulting object can be directly used as \code{mod_1} argument
in \code{\link{AMFEWMA_PhaseII}}
}
\details{
Among the multiple imputed datasets, the first one is used to build
the cleaned training and tuning sets for AMFEWMA.
}
\examples{
\dontrun{
set.seed(0)
dat_phaseI <- simulate_data_RoMFCC(p_cellwise = 0.05,
                            p_casewise = 0.05,
                            outlier = "outlier_E",
                            M_outlier_cell = 0.03,
                            M_outlier_case = 0.01,
                            max_n_cellwise = 10)
dat_phaseII <- simulate_data_RoMFCC(OC = "OC_E",
                                    M_OC = 0.01,
                                    which_OC = 5)
mfdobj_phaseI <- get_mfd_list(dat_phaseI$X_mat_list, n_basis = 5)
mfdobj_phaseII <- get_mfd_list(dat_phaseII$X_mat_list, n_basis = 5)
mfdobj_training_phaseI <- mfdobj_phaseI[1:333, ]
mfdobj_tuning_phaseI <- mfdobj_phaseI[334:1000, ]
out_phaseI <- RoAMFEWMA_PhaseI(mfdobj = mfdobj_training_phaseI,
                               mfdobj_tuning = mfdobj_tuning_phaseI)
out_phaseII <- RoAMFEWMA_PhaseII(mfdobj_2 = mfdobj_phaseII,
                                 mod_1 = out_phaseI)
plot_control_charts(out_phaseII$cc)
}
}
\references{
Capezza, C., Centofanti, F., Lepore, A., Palumbo, B. (2024)
Robust Multivariate Functional Control Chart.
\emph{Technometrics}, 66(4):531--547, \url{doi:10.1080/00401706.2024.2327346}.

Capezza, C., Capizzi, G., Centofanti, F., Lepore, A., Palumbo, B. (2025)
An Adaptive Multivariate Functional EWMA Control Chart.
\emph{Journal of Quality Technology},  57(1):1--15,
doi:https://doi.org/10.1080/00224065.2024.2383674.
}
