% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodetector.R
\name{factor_detector}
\alias{factor_detector}
\title{factor detector}
\usage{
factor_detector(y, x, confintv = FALSE, alpha = 0.95)
}
\arguments{
\item{y}{Variable Y, continuous numeric vector.}

\item{x}{Covariate X, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{confintv}{(optional) Whether to compute the confidence interval for the q statistic,
default is \code{FALSE}.}

\item{alpha}{(optional) Confidence level of the interval, default is \code{0.95}.}
}
\value{
A list.
\describe{
\item{\code{Q-statistic}}{the q statistic for factor detector}
\item{\code{P-value}}{the p value for factor detector}
\item{\code{CIL}}{the confidence interval lower bound}
\item{\code{CIU}}{the confidence interval upper bound}
}
}
\description{
The factor detector q-statistic measures the spatial stratified heterogeneity of a
variable Y, or the determinant power of a covariate X of Y.
}
\examples{
factor_detector(y = 1:7,x = c('x',rep('y',3),rep('z',3)))

}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
