% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mummer_alignment.R
\name{genbank_to_fasta}
\alias{genbank_to_fasta}
\title{Convert GenBank to FASTA Format}
\usage{
genbank_to_fasta(path, output_dir = NULL)
}
\arguments{
\item{path}{Path to the GenBank file.}

\item{output_dir}{Optional path for the output FASTA file. If NULL, the
output is saved in the same directory as the input file with the same base
name but with a .fasta extension.}
}
\value{
None explicitly, but writes the FASTA formatted data to a file.
}
\description{
This function reads a GenBank file, extracts the sequence and
writes it to a new file in FASTA format. It parses the DEFINITION and VERSION
for the header and sequences from the ORIGIN section.
}
\examples{
\donttest{
# Path to the example GenBank file in the package
gbk_file <- system.file("extdata", "BGC0000001.gbk", package = "geneviewer")

# Convert the GenBank file to FASTA format
genbank_to_fasta(gbk_file)
}


}
