% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_feats.R
\name{swap_query}
\alias{swap_query}
\title{Swap query and subject in blast-like feature tables}
\usage{
swap_query(x)
}
\arguments{
\item{x}{tibble with query and subject columns}
}
\value{
tibble with swapped query/subject columns
}
\description{
Swap query and subject columns in a table read with \code{\link[=read_feats]{read_feats()}} or
\code{\link[=read_links]{read_links()}}, for example, from blast searches. Swaps columns with
name/name2, such as 'seq_id/seq_id2', 'start/start2', ...
}
\examples{
feats <- tibble::tribble(
  ~seq_id, ~seq_id2, ~start, ~end, ~strand, ~start2, ~end2, ~evalue,
  "A", "B", 100, 200, "+", 10000, 10200, 1e-5
)
# make B the query
swap_query(feats)
}
