% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_lines.R
\name{draw_lines}
\alias{draw_lines}
\title{Draw Lines on a ggplot Object from Line Data}
\usage{
draw_lines(lines_data, zoom_level = 1, n = 100)
}
\arguments{
\item{lines_data}{A data frame containing line information. The expected columns include:
\itemize{
  \item \code{x_start}, \code{y_start}: Starting coordinates of the line.
  \item \code{x_end}, \code{y_end}: Ending coordinates of the line.
  \item \code{ctrl_x}, \code{ctrl_y}: Control points for curved lines (optional).
  \item \code{type}: Type of line (\code{"Straight Line"}, \code{"Curved Line"}, \code{"Straight Arrow"}, or \code{"Curved Arrow"}).
  \item \code{color}: Start color of the line (hexadecimal color code).
  \item \code{end_color}: End color of the line for gradients (hexadecimal color code).
  \item \code{color_type}: \code{"Gradient"} for gradient lines, or \code{"Single"} for solid-colored lines.
  \item \code{gradient_position}: Position of the gradient transition along the line (numeric, 0 to 1).
  \item \code{width}: Width of the line (numeric).
  \item \code{alpha}: Transparency of the line (numeric, 0 to 1).
  \item \code{arrow}: Logical, whether an arrowhead is used.
  \item \code{arrow_type}: Type of arrow (\code{"open"}, \code{"closed"}, etc.).
  \item \code{arrow_size}: Size of the arrowhead.
  \item \code{two_way}: Logical, whether the line has two arrowheads (bidirectional).
  \item \code{line_style}: Line style (\code{"solid"}, \code{"dashed"}, or \code{"dotted"}).
}}

\item{zoom_level}{Numeric. Adjusts the size of line widths and arrowheads relative to the plot. Default is \code{1}.}

\item{n}{Integer. Number of points for interpolation in gradient or curved lines. Default is \code{100}.}
}
\value{
ggplot2 line layers
}
\description{
This function overlays lines or arrows to a ggplot object based on line data. It supports straight lines, curved lines, gradient color transitions, and one-way or two-way arrows. The data can come from a CSV file generated by the ggsem Shiny app or custom input.
}
\examples{
library(ggplot2)

lines_df <- data.frame(
x_start = 11, y_start = -2.3, x_end = 21, y_end = 3.5,
ctrl_x = NA, ctrl_y = NA, ctrl_x2 = NA, ctrl_y2 = NA,
curvature_magnitude = NA, rotate_curvature = NA,
curvature_asymmetry = NA, type = 'Straight Line',
color = '#000000', end_color = NA, color_type = 'Single',
gradient_position = NA, width = 1, alpha = 1, arrow = TRUE,
arrow_type = 'closed', arrow_size = 0.1, two_way = FALSE,
lavaan = FALSE, network = FALSE, line_style = 'solid',
locked = FALSE, group = 1
)

p <- ggplot()

p + draw_lines(lines_data = lines_df, zoom_level = 1.2, n = 200)

}
