% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-grid.R
\name{gisco_get_grid}
\alias{gisco_get_grid}
\title{Grid dataset}
\source{
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/grids}.

There are specific downloading provisions, please see
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/grids}.
}
\usage{
gisco_get_grid(
  resolution = c(100, 50, 20, 10, 5, 2, 1),
  spatialtype = c("REGION", "POINT"),
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{resolution}{Resolution of the grid cells on kms. Available values are
\code{"1"}, \code{"2"}, \code{"5"}, \code{"10"}, \code{"20"}, \code{"50"}, \code{"100"}. See \strong{Details}.}

\item{spatialtype}{Select one of \code{"REGION"} or \code{"POINT"}.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed?. Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
These datasets contain grid cells covering the European land
territory, for various resolutions from 1km to 100km. Base statistics such
as population figures are provided for these cells.
}
\details{
Files are distributed on \href{https://epsg.io/3035}{\code{EPSG:3035}}.

The file sizes range is from 428Kb (\code{resolution = 100})
to 1.7Gb \code{resolution = 1}.
}
\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
grid <- gisco_get_grid(resolution = 20)

# If downloaded correctly proceed

if (!is.null(grid)) {
  library(dplyr)

  grid <- grid |>
    mutate(popdens = TOT_P_2021 / 20)

  breaks <- c(0, 0.1, 100, 500, 1000, 5000, 10000, Inf)

  # Cut groups
  grid <- grid |>
    mutate(popdens_cut = cut(popdens,
      breaks = breaks,
      include.lowest = TRUE
    ))

  cut_labs <- prettyNum(breaks, big.mark = " ")[-1]
  cut_labs[1] <- "0"
  cut_labs[7] <- "> 10 000"

  pal <- c("black", hcl.colors(length(breaks) - 2,
    palette = "Spectral",
    alpha = 0.9
  ))

  library(ggplot2)

  ggplot(grid) +
    geom_sf(aes(fill = popdens_cut), color = NA, linewidth = 0) +
    coord_sf(
      xlim = c(2500000, 7000000),
      ylim = c(1500000, 5200000)
    ) +
    scale_fill_manual(
      values = pal, na.value = "black",
      name = "people per sq. kilometer",
      labels = cut_labs,
      guide = guide_legend(
        direction = "horizontal",
        nrow = 1
      )
    ) +
    theme_void() +
    labs(
      title = "Population density in Europe",
      subtitle = "Grid: 20 km.",
      caption = gisco_attributions()
    ) +
    theme(
      text = element_text(colour = "white"),
      plot.background = element_rect(fill = "grey2"),
      plot.title = element_text(hjust = 0.5),
      plot.subtitle = element_text(hjust = 0.5, face = "bold"),
      plot.caption = element_text(
        color = "grey60", hjust = 0.5, vjust = 0,
        margin = margin(t = 5, b = 10)
      ),
      legend.position = "bottom",
      legend.title.position = "top",
      legend.text.position = "bottom",
      legend.key.height = unit(0.5, "lines"),
      legend.key.width = unit(1, "lines")
    )
}
\dontshow{\}) # examplesIf}
}
\concept{grids}
