% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotScatter}
\alias{PlotScatter}
\title{Make a scatter plot}
\usage{
PlotScatter(
  data,
  x = NULL,
  y = NULL,
  analysis = NULL,
  mode.slot = NULL,
  xcol = NULL,
  ycol = NULL,
  xlab = NULL,
  ylab = NULL,
  log = FALSE,
  log.x = log,
  log.y = log,
  axis = TRUE,
  axis.x = axis,
  axis.y = axis,
  remove.outlier = 1.5,
  show.outlier = TRUE,
  lim = NULL,
  xlim = lim,
  ylim = lim,
  size = 0.3,
  cross = NULL,
  diag = NULL,
  filter = NULL,
  genes = NULL,
  highlight = NULL,
  highlight.label = NULL,
  label = NULL,
  label.repel = 1,
  facet = NULL,
  color = NULL,
  colorpalette = NULL,
  colorbreaks = NULL,
  color.label = NULL,
  na.color = "grey50",
  density.margin = "n",
  density.n = 100,
  rasterize = NULL,
  correlation = NULL,
  correlation.x = -Inf,
  correlation.y = Inf,
  correlation.hjust = 0.5,
  correlation.vjust = 0.5,
  layers.below = NULL
)
}
\arguments{
\item{data}{the grandR object (can also be a plain data frame)}

\item{x}{an expression to compute the x value or a character corresponding to a sample (or cell) name or a fully qualified analysis result name (see details)}

\item{y}{an expression to compute the y value or a character corresponding to a sample (or cell) name or a fully qualified analysis result name (see details)}

\item{analysis}{the name of an analysis table (can be NULL; see details)}

\item{mode.slot}{the mode.slot (only relevant if data is a dense grandR object and analysis=NULL)}

\item{xcol}{a character corresponding to a sample (or cell) name or a fully qualified analysis result name (see details)}

\item{ycol}{a character corresponding to a sample (or cell) name or a fully qualified analysis result name (see details)}

\item{xlab}{the label for x (can be NULL, then the x parameter is used)}

\item{ylab}{the label for y (can be NULL, then the y parameter is used)}

\item{log}{if TRUE, use log scales for x and y axis}

\item{log.x}{if TRUE, use log scale for the x axis}

\item{log.y}{if TRUE, use log scale for the y axis}

\item{axis}{if FALSE, don't show x and y axes}

\item{axis.x}{if FALSE, don't show the x axis}

\item{axis.y}{if FALSE, don't show the y axis}

\item{remove.outlier}{configure how outliers are selected (is the coef parameter to \link[grDevices]{boxplot.stats}); can be FALSE, in which case no points are considered outliers (see details)}

\item{show.outlier}{if TRUE, show outlier as gray points at the border of the plotting plane}

\item{lim}{define the both x and y axis limits (vector of length 2 defining the lower and upper bound, respectively)}

\item{xlim}{define the x axis limits (vector of length 2 defining the lower and upper bound, respectively)}

\item{ylim}{define the y axis limits (vector of length 2 defining the lower and upper bound, respectively)}

\item{size}{the point size to use}

\item{cross}{add horizontal and vertical lines through the origin?}

\item{diag}{if TRUE, add main diagonal; if numeric vector, add these diagonals}

\item{filter}{restrict to these rows; is evaluated for the data frame, and should result in a logical vector}

\item{genes}{restrict to these genes; can be either numeric indices, gene names, gene symbols or a logical vector}

\item{highlight}{highlight these genes; can be either numeric indices, gene names, gene symbols, a logical vector or a list thereof (see details)}

\item{highlight.label}{labels for the highlighted genes (see details)}

\item{label}{label these genes; can be either numeric indices, gene names, gene symbols or a logical vector (see details)}

\item{label.repel}{force to repel labels from points and each other (increase if labels overlap)}

\item{facet}{an expression (evaluated in the same environment as x and y); for each unique value a panel (facet) is created; can be NULL}

\item{color}{either NULL (use point density colors), or a name of the \link{GeneInfo} table (use scale_color_xxx to define colors), or a color for all points}

\item{colorpalette}{either NULL (use default colors), or a palette name from color brewer or viridis}

\item{colorbreaks}{either NULL (use default algorithm of using quantiles of the values), or "minmax" for 5 breaks in between the minimum and maximum of the values, or the actual color breaks to distribute the colors from the palette}

\item{color.label}{the label for the color legend}

\item{na.color}{the color for NA values}

\item{density.margin}{for density colors, one of 'n','x' or 'y'; should the density be computed along both axes ('n'), or along 'x' or 'y' axis only}

\item{density.n}{how many bins to use for density calculation (see \link[MASS]{kde2d})}

\item{rasterize}{use ggrastr to rasterize points? (can be NULL, see details)}

\item{correlation}{a function to format correlation statistics to be annotated (see details)}

\item{correlation.x}{x coordinate to put the correlation annotation in the plot (see details)}

\item{correlation.y}{y coordinate to put the correlation annotation in the plot (see details)}

\item{correlation.hjust}{x adjustment to put the correlation annotation in the plot (see details)}

\item{correlation.vjust}{y adjustment to put the correlation annotation in the plot (see details)}

\item{layers.below}{list of ggplot geoms to add before adding the layer containing the points}
}
\value{
a ggplot object with the data frame used as the df attribute
}
\description{
Convenience method to compare two variables (slot data or analyses results).
}
\details{
Both the x and y parameter are either expressions or names. Names are either sample (or cell, in case of single cell experiments) names or
fully qualified analysis results (analysis name followed by a dot and the analysis result table column). If the analysis parameter is given, the analysis
name must be omitted from x and y. These names can be used within expressions using non-standard evaluation.
Defining by names only works with character literals like "kinetics.Synthesis", but if you give an expression (e.g. a variable name that contains a character),
the situation is more complicated, since PlotScatter will try to evaluate this for defining the values, not the name of the column. If the expression evaluates
into a single character string that is equal to a name (see above!), PlotScatter knows what to do. For more complicated situations that cannot be resolved by this,
you can use the xcol and ycol parameters instead of the x and y parameters!

By default the limits of x and y axis are chosen after removing outliers (using the same algorithm used for \link{boxplot}). Thus, larger numbers filter
less stringently. remove.outlier can also be set to FALSE (no outlier filtering). If xlim or ylim are set, this overrides outlier filtering. Points outside of the limits
(i.e. outliers or points outside of xlim or ylim) are set to infinity (such that they are shown at the border of the plot in gray)

By default, all genes are shown. This can be restricted using the \code{genes} parameter (see \link{ToIndex}). It is also possible to highlight a subset of the genes
using \code{highlight}. This parameter either describes a subset of the genes (either numeric indices, gene names, gene symbols or a logical vector), in which case these genes
are plotted in red and with larger points size, or it can be a list of such vectors. The names of this list must be valid colors. Genes can also be labeled (make sure that this
is really only a small subset of the genes).

When rendering to vector based devices (such as svg or pds), a genome-wide scatterplot often is painfully big (and rendering therefore slow). The \code{rasterize}
parameter can be used to automatically rasterize the points only (via the ggrastr package). If this parameter is NULL, ggrastr is used if more than 1000 points are plotted!

Often scatter plots show that x and y coordinates are correlated. Correlations can be annotated using the \link{FormatCorrelation} function. Most often you will use
\code{PlotScatter(data,x,y,correlation=FormatCorrelation())}. To use a different correlation measure, other formats for correlation coefficient and P values or omit one of these
statistics, parametrize \code{FormatCorrelation}. Use correlation.x and correlation.y to place the annotation in the plot, and correlation.hjust/correlation.vjust to align the
annotation at the given x,y coordinates. Infinite values for correlation.x/correlation.y will put the annotation at the border of the plot.
}
\concept{globalplot}
