% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmtree-fscores.R
\name{generate_node_scores_dataset}
\alias{generate_node_scores_dataset}
\title{Generate Combined Dataset with Node Assignments and Factor Scores}
\usage{
generate_node_scores_dataset(grmtree_obj, method = "EAP")
}
\arguments{
\item{grmtree_obj}{A GRM tree object (from \code{grmtree()} function).}

\item{method}{Scoring method to use: "EAP" (default), "MAP", "ML", or "WLE".}
}
\value{
A data.frame containing:
- Original variables from the model frame
- 'node': Factor indicating terminal node membership (e.g., "Node 1")
- 'factor_score': Computed latent factor scores
Rows are in original order with sequential row names.
}
\description{
Creates a dataset combining original data with node assignments and computed
factor scores. Maintains original row order while adding node membership and
factor score information.
}
\examples{
\donttest{
  library(grmtree)
  library(hlt)
  data("asti", package = "hlt")
  asti$resp <- data.matrix(asti[, 1:4])

  # Fit GRM tree with gender and group as partitioning variables
  tree <- grmtree(resp ~ gender + group,
          data = asti,
          control = grmtree.control(minbucket = 30))

# Generate combined dataset
scored_data <- generate_node_scores_dataset(tree)

# Plot scores by node
boxplot(factor_score ~ node, data = scored_data)
}

}
\seealso{
\code{\link{grmtree}} fits a Graded Response Model Tree,
\code{\link{grmforest}} for GRM Forests, \code{\link{fscores_grmtree}} for
computing factor scores, \code{\link{threshpar_grmtree}} for extracting
threshold parameters, \code{\link{discrpar_grmtree}} for extracting
discrimination parameters, \code{\link{itempar_grmtree}} for extracting item
parameters
}
