% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmtree-threshpar.R
\name{threshpar_grmtree}
\alias{threshpar_grmtree}
\title{Extract Threshold Parameters from GRM Tree}
\usage{
threshpar_grmtree(object, node = NULL, ...)
}
\arguments{
\item{object}{A \code{grmtree} object.}

\item{node}{Optional vector of node IDs to extract from. If NULL (default),
extracts from all terminal nodes.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data.frame with threshold parameters for each item in each node,
with columns: \item{Node}{Node ID} \item{Item}{Item name} \item{d1, d2,
...}{Threshold parameters for each category}
}
\description{
Extracts threshold parameters for each item from all terminal nodes of a
graded response model tree. The thresholds represent the points on the latent
trait continuum where the probability of scoring in adjacent response
categories is equal.
}
\examples{
\donttest{
  library(grmtree)
  library(hlt)

  data("asti", package = "hlt")
  asti$resp <- data.matrix(asti[, 1:4])

  # Fit GRM tree with gender and group as partitioning variables
  tree <- grmtree(resp ~ gender + group,
          data = asti,
          control = grmtree.control(minbucket = 30))

  # Get all thresholds
  thresholds <- threshpar_grmtree(tree)
  print(thresholds)

}

}
\seealso{
\code{\link{grmtree}} fits a Graded Response Model Tree,
\code{\link{grmforest}} for GRM Forests, \code{\link{fscores_grmtree}} for
computing factor scores, \code{\link{discrpar_grmtree}} for extracting
discrimination parameters, \code{\link{itempar_grmtree}} for extracting item
parameters
}
