% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_footnote_order}
\alias{opt_footnote_order}
\title{Option to modify the order of footnotes}
\usage{
opt_footnote_order(data, order = "marks_last")
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{order}{\emph{Method for ordering footnote marks}

\verb{scalar<character>} // \emph{default:} \code{"marks_last"}

A keyword provided here will determine how marked footnotes will be
arranged in relation to unmarked footnotes. Use either: \code{"marks_last"},
\code{"marks_first"}, or \code{"preserve_order"}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
We can alter the order in which marked footnotes appear in relation to any
unmarked footnotes in the footer section of the table. A single keyword is to
be supplied and it will determine whether marked footnotes should appear:
(1) before unmarked, (2) after unmarked, or (3) in call order.
}
\section{Specification of footnote order}{


The keywords are:
\itemize{
\item \code{"marks_last"}: marked footnotes should appear beneath unmarked in the
table (default)
\item \code{"marks_first"}: marked footnotes should appear before unmarked in the
table
\item \code{"preserve_order"}: footnotes will appear in the order they were specified
in \code{\link[=tab_footnote]{tab_footnote()}}
}
}

\section{Examples}{


Use a summarized version of the \code{\link{sza}} dataset to create a \strong{gt} table,
adding three marked footnotes and one unmarked (with four calls of
\code{\link[=tab_footnote]{tab_footnote()}}). We can modify the order of footnotes with the
\code{opt_footnote_order()} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sza |>
  dplyr::filter(latitude == 30) |>
  dplyr::group_by(tst) |>
  dplyr::summarize(
    SZA.Max = if (
      all(is.na(sza))) \{
      NA
    \} else \{
      max(sza, na.rm = TRUE)
    \},
    SZA.Min = if (
      all(is.na(sza))) \{
      NA
    \} else \{
      min(sza, na.rm = TRUE)
    \},
    .groups = "drop"
  ) |>
  gt(rowname_col = "tst") |>
  tab_spanner_delim(delim = ".") |>
  sub_missing(
    columns = everything(),
    missing_text = "90+"
  ) |>
  tab_stubhead(label = "TST") |>
  tab_footnote(
    footnote = "True solar time.",
    locations = cells_stubhead()
  ) |>
  tab_footnote(
    footnote = "Solar zenith angle.",
    locations = cells_column_spanners(
      spanners = "spanner-SZA.Max"
    )
  ) |>
  tab_footnote(
    footnote = "The Lowest SZA.",
    locations = cells_stub(rows = "1200")
  ) |>
  tab_footnote(
    footnote = "Values calculated on the first of every month."
  ) |>
  opt_footnote_order(order = "marks_first")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_footnote_order_1.png" alt="This image of a table was generated from the first code example in the `opt_footnote_order()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

10-5
}

\section{Function Introduced}{

\code{v0.1.1.9000} (September 22, 2025)
}

\seealso{
Other table option functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_footnote_spec}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_interactive}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_stylize}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{table option functions}
