% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmo_mp.R
\name{hmo_mp}
\alias{hmo_mp}
\title{Motif discovery using Matrix Profile}
\usage{
hmo_mp(mode = "stamp", w, qtd)
}
\arguments{
\item{mode}{Character. Algorithm: one of "stomp", "stamp", "simple",
"mstomp", "scrimp", "valmod", "pmp".}

\item{w}{Integer. Subsequence window size.}

\item{qtd}{Integer. Minimum number of occurrences to classify as a motif.}
}
\value{
\code{hmo_mp} object.
}
\description{
Discovers repeated subsequences (motifs) using Matrix Profile methods as
implemented in the \code{tsmp} package \url{doi:10.32614/RJ-2020-021}.
}
\examples{
library(daltoolbox)

# Load motif example data
data(examples_motifs)

# Use a simple sequence example
dataset <- examples_motifs$simple
head(dataset)

# Configure motif discovery via Matrix Profile
model <- hmo_mp("stamp", 4, 3)

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected motifs
print(detection[(detection$event),])

}
\references{
\itemize{
\item Yeh CCM, et al. (2016). Matrix Profile I/II: All-pairs similarity joins and scalable
time series motifs/discrod discovery. IEEE ICDM.
\item Tavenard R, et al. tsmp: The Matrix Profile in R. The R Journal (2020). doi:10.32614/RJ-2020-021
}
}
