% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broad-sense.R
\name{H2_Delta}
\alias{H2_Delta}
\title{Calculate average heritability of differences between genotypes from model object}
\usage{
H2_Delta(model,
         target,
         type = c("BLUP", "BLUE"),
         aggregate = c("arithmetic", "harmonic"),
         options
         )
}
\arguments{
\item{model}{Model object of class \code{lmerMod/merMod} or \code{asreml}}

\item{target}{The name of the random effect for which heritability is to be calculated.}

\item{type}{character, whether heritability is calculated using BLUEs or BLUPs}

\item{aggregate}{character, when taking means in the calculation, should harmonic or arithmetic mean be used?}

\item{options}{NULL by default, for internal checking of model object before calculations}
}
\value{
Numeric
}
\description{
Instead of computing heritability on a "entry-mean" basis, this method
calculates heritability using "entry-differences". Entry here is
referring to the genotype, line or variety of interest. See
reference for origin and interpretation of \code{H2_Delta} and it's variants
}
\details{
The heritability of differences between genotypes is given by:

\deqn{H^2_{\Delta ..} = 1 - \frac{PEV^{BLUP}_{\overline\Delta ..}}{2\sigma^2_g}}

where:
\itemize{
\item \eqn{PEV^{BLUP}_{\overline\Delta ..}} is the mean of the prediction error variance matrix for the pairwise differences among BLUPs (BLUEs if \code{method = "BLUE"}) across all genotypes
\item \eqn{\sigma^2} is the variance attributed to differences between genotype
}

See reference page 995 - 997 for full derivation of this heritability measure and related variants
}
\examples{
# lme4 model
lettuce_subset <- lettuce_phenotypes |> subset(loc == "L2")
lettuce_lme4 <- lme4::lmer(y ~ rep + (1 | gen), data = lettuce_subset)
H2_Delta(lettuce_lme4, target = "gen", type = "BLUP")

# asreml model (Requires license)
\dontrun{
lettuce_asreml <- asreml::asreml(fixed = y ~ rep,
                                 random = ~ gen,
                                 data = lettuce_subset,
                                 trace = FALSE
                                 )

H2_Delta(lettuce_asreml, target = "gen", type = "BLUP")
}
}
\references{
Schmidt, P., Hartung, J., Rath, J., & Piepho, H.-P. (2019). Estimating Broad-Sense Heritability with Unbalanced Data from Agricultural Cultivar Trials. Crop Science, 59(2), 525–536. https://doi.org/10.2135/cropsci2018.06.0376
}
\seealso{
\code{\link[=H2_Delta_by_genotype]{H2_Delta_by_genotype()}}, \code{\link[=H2_Delta_pairwise]{H2_Delta_pairwise()}}
}
