% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametise.R
\name{H2_Oakey_parameters}
\alias{H2_Oakey_parameters}
\title{Calculate Oakey's heritability using variance parameters}
\usage{
H2_Oakey_parameters(Gg_inv, C_gg)
}
\arguments{
\item{Gg_inv}{The inverse of the genotypic variance-covariance matrix.}

\item{C_gg}{Prediction error variance matrix associated with the genotype effects.}
}
\value{
Numeric value
}
\description{
Rather than providing a model object, supply the necessary components to compute
this heritability measure.
}
\examples{
Gg_inv = diag(1/0.15, 3, 3)
C_gg <- matrix(
  c(
    0.08, 0.01, 0.00,
    0.01, 0.07, 0.01,
    0.00, 0.01, 0.09
  ),
  nrow = 3, byrow = TRUE
)
H2_Oakey_parameters(Gg_inv, C_gg)
}
