% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_icosa_tri_to_plane}
\alias{hexify_icosa_tri_to_plane}
\title{Convert Icosa Triangle coordinates to PLANE coordinates}
\usage{
hexify_icosa_tri_to_plane(
  icosa_triangle_face,
  icosa_triangle_x,
  icosa_triangle_y
)
}
\arguments{
\item{icosa_triangle_face}{Triangle face number (0-19), integer or vector}

\item{icosa_triangle_x}{X coordinate on triangle face}

\item{icosa_triangle_y}{Y coordinate on triangle face}
}
\value{
Data frame with columns:
\item{plane_x}{X coordinate in PLANE space (range ~0 to 5.5)}
\item{plane_y}{Y coordinate in PLANE space (range ~0 to 1.73)}
}
\description{
Transforms icosahedral triangle coordinates to the 2D PLANE representation
(unfolded icosahedron). Each triangle is rotated and translated to its
position in the unfolded layout.
}
\details{
Equivalent to 'dggridR' dgPROJTRI_to_PLANE().

The PLANE layout arranges all 20 icosahedral faces into a roughly
rectangular region. Faces 0-4 and 5-9 form the upper row, while
faces 10-14 and 15-19 form the lower row. Adjacent faces share
edges in this representation.
}
\examples{
# Get PLANE coordinates from triangle coordinates
fwd <- hexify_forward(lon = 2.35, lat = 48.86)
plane <- hexify_icosa_tri_to_plane(
  icosa_triangle_face = fwd["face"],
  icosa_triangle_x = fwd["icosa_triangle_x"],
  icosa_triangle_y = fwd["icosa_triangle_y"]
)
print(plane)
}
\seealso{
\code{\link{hexify_cell_to_plane}} for direct cell ID conversion,
\code{\link{hexify_lonlat_to_plane}} for lon/lat to PLANE

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
