% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_quad_xy_to_cell}
\alias{hexify_quad_xy_to_cell}
\title{Convert Quad XY coordinates to Cell ID}
\usage{
hexify_quad_xy_to_cell(quad, quad_x, quad_y, resolution, aperture = 3L)
}
\arguments{
\item{quad}{Quad number (0-11), integer or vector}

\item{quad_x}{Continuous X coordinate in quad space}

\item{quad_y}{Continuous Y coordinate in quad space}

\item{resolution}{Grid resolution level (0-30)}

\item{aperture}{Grid aperture: 3, 4, or 7}
}
\value{
Numeric vector of cell IDs
}
\description{
Converts Quad XY coordinates (continuous quad space) to DGGRID-compatible
cell IDs. The coordinates are quantized to the nearest cell.
}
\details{
Compatible with 'dggridR' dgQ2DD_to_SEQNUM().
}
\examples{
# Convert Quad XY to cell ID
cell_id <- hexify_quad_xy_to_cell(quad = 1, quad_x = 0.5, quad_y = 0.3,
                                   resolution = 10, aperture = 3)
print(cell_id)
}
\seealso{
\code{\link{hexify_cell_to_quad_xy}} for the inverse operation,
\code{\link{hexify_quad_ij_to_cell}} for integer grid coordinates

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
