% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_importance.R
\name{pd_importance}
\alias{pd_importance}
\alias{pd_importance.default}
\alias{pd_importance.hstats}
\title{PD Bases Importance (Experimental)}
\usage{
pd_importance(object, ...)

\method{pd_importance}{default}(object, ...)

\method{pd_importance}{hstats}(
  object,
  normalize = TRUE,
  squared = TRUE,
  sort = TRUE,
  zero = TRUE,
  ...
)
}
\arguments{
\item{object}{Object of class "hstats".}

\item{...}{Currently unused.}

\item{normalize}{Should statistics be normalized? Default is \code{TRUE}.}

\item{squared}{Should \emph{squared} statistics be returned? Default is \code{TRUE}.}

\item{sort}{Should results be sorted? Default is \code{TRUE}.
(Multi-output is sorted by row means.)}

\item{zero}{Should rows with all 0 be shown? Default is \code{TRUE}.}
}
\value{
An object of class "hstats_matrix" containing these elements:
\itemize{
\item \code{M}: Matrix of statistics (one column per prediction dimension), or \code{NULL}.
\item \code{SE}: Matrix with standard errors of \code{M}, or \code{NULL}.
Multiply with \code{sqrt(m_rep)} to get \emph{standard deviations} instead.
Currently, supported only for \code{\link[=perm_importance]{perm_importance()}}.
\item \code{m_rep}: The number of repetitions behind standard errors \code{SE}, or \code{NULL}.
Currently, supported only for \code{\link[=perm_importance]{perm_importance()}}.
\item \code{statistic}: Name of the function that generated the statistic.
\item \code{description}: Description of the statistic.
}
}
\description{
Experimental variable importance method based on partial dependence functions.
While related to Greenwell et al., our suggestion measures not only main effect
strength but also interaction effects. It is very closely related to \eqn{H^2_j},
see Details. Use \code{plot()} to get a barplot.
}
\details{
If \eqn{x_j} has no effects, the (centered) prediction function \eqn{F}
equals the (centered) partial dependence \eqn{F_{\setminus j}} on all other
features \eqn{\mathbf{x}_{\setminus j}}, i.e.,
\deqn{
    F(\mathbf{x}) = F_{\setminus j}(\mathbf{x}_{\setminus j}).
}
Therefore, the following measure of variable importance follows:
\deqn{
  \textrm{PDI}_j = \frac{\frac{1}{n} \sum_{i = 1}^n\big[F(\mathbf{x}_i) - 
  \hat F_{\setminus j}(\mathbf{x}_{i\setminus j})\big]^2}{\frac{1}{n} \sum_{i = 1}^n
  \big[F(\mathbf{x}_i)\big]^2}.
}
It differs from \eqn{H^2_j} only by not subtracting the main effect of the \eqn{j}-th
feature in the numerator. It can be read as the proportion of prediction variability
unexplained by all other features. As such, it measures variable importance of
the \eqn{j}-th feature, including its interaction effects (check \code{\link[=partial_dep]{partial_dep()}}
for all definitions).

Remarks 1 to 4 of \code{\link[=h2_overall]{h2_overall()}} also apply here.
}
\section{Methods (by class)}{
\itemize{
\item \code{pd_importance(default)}: Default method of PD based feature importance.

\item \code{pd_importance(hstats)}: PD based feature importance from "hstats" object.

}}
\examples{
# MODEL 1: Linear regression
fit <- lm(Sepal.Length ~ . , data = iris)
s <- hstats(fit, X = iris[, -1])
plot(pd_importance(s))

# MODEL 2: Multi-response linear regression
fit <- lm(as.matrix(iris[, 1:2]) ~ Petal.Length + Petal.Width + Species, data = iris)
s <- hstats(fit, X = iris[, 3:5])
plot(pd_importance(s))
}
\references{
Greenwell, Brandon M., Bradley C. Boehmke, and Andrew J. McCarthy.
\emph{A Simple and Effective Model-Based Variable Importance Measure.} Arxiv (2018).
}
\seealso{
\code{\link[=hstats]{hstats()}}, \code{\link[=perm_importance]{perm_importance()}}
}
