% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-schema.R
\name{get_schema_url}
\alias{get_schema_url}
\title{Get the JSON schema download URL for a given config file version}
\usage{
get_schema_url(config = c("tasks", "admin", "model"), version, branch = "main")
}
\arguments{
\item{config}{Name of config file to validate. One of \code{"tasks"} or \code{"admin"}.}

\item{version}{A valid version of hubverse
\href{https://github.com/hubverse-org/schemas}{schema}
(e.g. \code{"v0.0.1"}).}

\item{branch}{The branch of the hubverse
\href{https://github.com/hubverse-org/schemas}{schemas repository}
from which to fetch schema. Defaults to \code{"main"}.}
}
\value{
The JSON schema download URL for a given config file version.
}
\description{
Get the JSON schema download URL for a given config file version
}
\examples{
\dontshow{if (asNamespace("hubUtils")$not_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_schema_url(config = "tasks", version = "v0.0.0.9")
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions supporting config file validation: 
\code{\link{get_schema}()},
\code{\link{get_schema_valid_versions}()}
}
\concept{functions supporting config file validation}
