% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_get_ferrybox_data.R
\name{ifcb_get_ferrybox_data}
\alias{ifcb_get_ferrybox_data}
\title{Retrieve Ferrybox Data for Specified Timestamps}
\usage{
ifcb_get_ferrybox_data(
  timestamps,
  ferrybox_folder,
  parameters = c("8002", "8003"),
  ship = "SveaFB",
  latitude_param = "8002",
  longitude_param = "8003",
  timestamp_param = "38059",
  max_time_diff_min = 1
)
}
\arguments{
\item{timestamps}{A vector of POSIXct timestamps for which GPS coordinates and associated parameter data are to be retrieved.}

\item{ferrybox_folder}{A string representing the path to the folder containing Ferrybox \code{.txt} files.}

\item{parameters}{A character vector specifying the parameters to extract from the Ferrybox data. Defaults to \code{c("8002", "8003")}.}

\item{ship}{A string representing the name of the ship to filter Ferrybox files. The default is "SveaFB".}

\item{latitude_param}{A string specifying the header name for the latitude column in the Ferrybox data. Default is "8002".}

\item{longitude_param}{A string specifying the header name for the longitude column in the Ferrybox data. Default is "8003".}

\item{timestamp_param}{A string specifying the header name for the timestamp column in the Ferrybox data. Default is "38059".}

\item{max_time_diff_min}{Numeric. Maximum allowed difference (in minutes) between the requested timestamp and the closest available Ferrybox data.
Defaults to 1 minutes. Timestamps further away than this threshold will not be used for filling missing data.}
}
\value{
A data frame containing the input timestamps and corresponding data for the specified parameters.
Columns include 'timestamp', 'gpsLatitude', 'gpsLongitude' (if applicable), and the specified parameters.
}
\description{
This internal SMHI function reads \code{.txt} files from a specified folder containing Ferrybox data,
filters them based on a specified ship name (default is "SveaFB" for R/V Svea), and extracts
data (including GPS coordinates) for timestamps (rounded to the nearest minute) falling within the date ranges defined in the file names.
}
\details{
The function extracts data from files whose names match the specified ship and fall within the date ranges defined in the file names. The columns corresponding to \code{latitude_param} and \code{longitude_param} will be renamed to \code{gpsLatitude} and \code{gpsLongitude}, respectively, if they are present in the \code{parameters} argument.

The function also handles cases where the exact timestamp is missing by attempting to interpolate the data using floor and ceiling rounding methods. The final output will ensure that all specified parameters are numeric.
}
\examples{
\dontrun{
ferrybox_folder <- "/path/to/ferrybox/data"
timestamps <- as.POSIXct(c("2016-08-10 10:47:34 UTC",
                           "2016-08-10 11:12:21 UTC",
                           "2016-08-10 11:35:59 UTC"))

result <- ifcb_get_ferrybox_data(timestamps, ferrybox_folder)
print(result)
}

}
