% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lav_slopes.R
\name{lav_slopes}
\alias{lav_slopes}
\alias{print.lav_slopes}
\alias{summary.lav_slopes}
\title{Simple slopes and interaction plots for fitted 'lavaan' models}
\usage{
lav_slopes(
  fit,
  outcome,
  pred,
  modx,
  interaction,
  data = NULL,
  modx.values = NULL,
  modx.labels = NULL,
  pred.range = NULL,
  conf.level = 0.95,
  x.label = NULL,
  y.label = NULL,
  legend.title = NULL,
  colors = NULL,
  line.size = 0.80,
  alpha = 0.20,
  table = TRUE,
  digits = 2,
  modx_n_unique_cutoff = 4L,
  return_data = FALSE
)

\method{print}{lav_slopes}(x, ...)

\method{summary}{lav_slopes}(object, ...)
}
\arguments{
\item{fit}{A fitted 'lavaan' object that includes the product term (required).}

\item{outcome}{Character. Name of the dependent variable in \code{fit} (required).}

\item{pred}{Character. Name of the focal predictor whose simple slopes are probed (required).}

\item{modx}{Character. Name of the moderator (required).}

\item{interaction}{Character. Name of the product term in \code{fit} (e.g., \code{"X_Z"}) (required).}

\item{data}{\code{data.frame}. Raw data. If \code{NULL}, the function tries to pull
data from \code{fit} via \code{lavInspect}.}

\item{modx.values}{Numeric or character vector. Values or levels of the moderator
at which to compute slopes; derived automatically when \code{NULL}.}

\item{modx.labels}{Character vector. Legend/table labels for \code{modx.values}
(default: the character form of \code{modx.values}).}

\item{pred.range}{Numeric length-2. Range \code{c(min, max)} for the x-axis;
uses observed range in \code{data} when available, else \code{c(-2, 2)}.}

\item{conf.level}{Numeric in (0,1). Confidence level for CIs and ribbons (default: 0.95).}

\item{x.label}{Character. X-axis label (default: \code{pred}).}

\item{y.label}{Character. Y-axis label (default: \code{outcome}).}

\item{legend.title}{Character. Legend title; if \code{NULL}, the legend shows only levels (default: NULL).}

\item{colors}{Character vector. Colors for lines and ribbons; named vector recommended with names matching \code{modx.labels} (default: Okabe-Ito palette).}

\item{line.size}{Numeric > 0. Line width (default: 0.80).}

\item{alpha}{Numeric in (0,1). Ribbon opacity (default 0.20).}

\item{table}{Logical. Print APA-style interaction test and simple-slopes table (default: \code{TRUE}).}

\item{digits}{Integer \code{>= 0}. Decimal digits in printed output (default: 2).}

\item{modx_n_unique_cutoff}{Integer \code{>= 1}. Threshold for treating a numeric moderator
as continuous and using mean ± SD (default: 4).}

\item{return_data}{Logical. If \code{TRUE}, include the plotting data.frame in the returned list (default: FALSE).}

\item{x}{A 'lav_slopes' object.}

\item{...}{Additional arguments; unused.}

\item{object}{A 'lav_slopes' object.}
}
\value{
A list with elements:
\describe{
  \item{\code{plot}}{\code{ggplot} object with lines and confidence ribbons.}
  \item{\code{slope_table}}{Data frame with moderator levels, simple slopes, SE, z, and CI.}
  \item{\code{plot_data}}{Only when \code{return_data = TRUE}: data used to build the plot.}
}
}
\description{
Computes conditional (simple) slopes of a focal predictor across values
of a moderator from a fitted 'lavaan' model that includes their explicit 
product term. Plots predicted lines with Wald confidence ribbons, and print 
an APA-style test of the interaction for easy reporting and interpretation,
plus a simple-slopes table.
}
\details{
The model should include a main effect for the predictor, a main effect for the moderator,
and their product term. The simple slope of the predictor at a given moderator value
combines the predictor main effect with the interaction term. The moderator can 
be continuous or categorical. Standard errors use the delta method with the 
model covariance matrix of the estimates.
}
\section{Notes}{

Estimates are unstandardized; a standardized beta for the interaction is also reported
for reference. Wald tests assume large-sample normality of estimates.
}

\examples{
set.seed(42)
X <- rnorm(100); Z <- rnorm(100); X_Z <- X*Z
Y <- 0.6*X + 0.6*Z + 0.3*X_Z + rnorm(100, sd = 0.7) 
dataset <- data.frame(Y, X, Z, X_Z)
fit <- lavaan::sem("Y ~ X + Z + X_Z", data = dataset)
lav_slopes(
fit = fit, 
data = dataset,
outcome = "Y", 
pred = "X", 
modx = "Z", 
interaction = "X_Z")

}
