% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defuzz.R
\name{defuzz}
\alias{defuzz}
\title{Convert fuzzy set into a crisp numeric value}
\usage{
defuzz(
  degrees,
  values,
  type = c("mom", "fom", "lom", "dee", "cog", "expun", "expw1", "expw2")
)
}
\arguments{
\item{degrees}{A fuzzy set in the form of a numeric vector of membership
degrees of values provided as the \code{values} argument.}

\item{values}{A universe for the fuzzy set.}

\item{type}{Type of the requested defuzzification method. The possibilities are:
\itemize{
\item \code{'mom'}: Mean of Maxima - maximum membership degrees are
found and a mean of values that correspond to that degrees is returned;
\item \code{'fom'}: First of Maxima - first value with maximum membership
degree is returned;
\item \code{'lom'}: Last of Maxima - last value with maximum membership degree
is returned;
\item \code{'dee'}: Defuzzification of Evaluative Expressions - method used
by the \code{\link[=pbld]{pbld()}} inference mechanism that combines the former three
approaches according to the shape of the \code{degrees} vector:
If \code{degrees} is non-increasing then \code{'lom'} type is used,
if it is non-decreasing then \code{'fom'} is applied, else \code{'mom'} is selected;
\item \code{'cog'}: Center of Gravity - the result is a mean of \code{values} weighted by \code{degrees};
\item \code{'exp1'}: Experimental 1.
}}
}
\value{
A defuzzified value.
}
\description{
Take a discretized fuzzy set (i.e., a vector of membership degrees and a vector
of numeric values that correspond to that degrees) and perform a selected
type of defuzzification, i.e., conversion of the fuzzy set into a single
crisp value.
}
\details{
Function converts input fuzzy set into a crisp value. The definition of
input fuzzy set is provided by the arguments \code{degrees} and
\code{values}. These arguments should be numeric vectors of the same length,
the former containing membership degrees in the interval \eqn{[0, 1]} and
the latter containing the corresponding crisp values: i.e., \code{values[i]}
has a membership degree \code{degrees[i]}.
}
\examples{

# returns mean of maxima, i.e., mean of 6, 7, 8
defuzz(c(0, 0, 0, 0.1, 0.3, 0.9, 0.9, 0.9, 0.2, 0),
       1:10,
       type='mom')

}
\seealso{
\code{\link[=fire]{fire()}}, \code{\link[=aggregateConsequents]{aggregateConsequents()}}, \code{\link[=perceive]{perceive()}}, \code{\link[=pbld]{pbld()}}, \code{\link[=fcut]{fcut()}}, \code{\link[=lcut]{lcut()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
