# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# afcon_poly

library(testthat)

# Test 1: Confirm the object is a data.frame
test_that("afcon_poly is a data.frame", {
  expect_s3_class(afcon_poly, "data.frame")
})

# Test 2: Confirm it has exactly 5 columns
test_that("afcon_poly has 5 columns", {
  expect_equal(length(afcon_poly), 5)
})

# Test 3: Confirm it has exactly 42 rows
test_that("afcon_poly has 42 rows", {
  expect_equal(nrow(afcon_poly), 42)
})

# Test 4: Confirm column names are correct
test_that("afcon_poly has correct column names", {
  expect_named(afcon_poly, c("x", "y", "totcon", "name", "id"))
})

# Test 5: Confirm column types are as expected
test_that("afcon_poly columns have correct types", {
  expect_type(afcon_poly$x, "double")
  expect_type(afcon_poly$y, "double")
  expect_type(afcon_poly$totcon, "double")
  expect_s3_class(afcon_poly$name, "factor")
  expect_type(afcon_poly$id, "double")
})
