% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linevis.R
\name{linevis-shiny}
\alias{linevis-shiny}
\alias{linevisOutput}
\alias{renderLinevis}
\title{Shiny bindings for linevis}
\usage{
linevisOutput(outputId, width = "100\%", height = "auto")

renderLinevis(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended. \code{height} will probably not
have an effect; instead, use the \code{height} parameter in
\code{\link[linevis]{linevis}}.}

\item{expr}{An expression that generates a linevis}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
Htmlwidgets render and output objects
}
\description{
Output and render functions for using linevis within Shiny
applications and interactive Rmd documents.
}
\examples{
if (interactive()) {
library(shiny)

#----------------------- Most basic example -----------------
shinyApp(
  ui = fluidPage(linevisOutput("graph2d")),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis()
    )
  }
)


#----------------------- More advanced example -----------------
df_data = data.frame(x = c('2014-06-11',
                           '2014-06-12',
                           '2014-06-13',
                           '2014-06-14',
                           '2014-06-15',
                           '2014-06-16'),
                     y = c(0,
                           1,
                           30000,
                           10,
                           150,
                           30000,
                           20,
                           20))

ui <- fluidPage(
  linevisOutput("appts"),
  div("Visible window:", textOutput("window", inline = TRUE)),
  tableOutput("table")
)

server <- function(input, output) {
  output$appts <- renderLinevis(
    linevis(df_data)
  )

  output$window <- renderText(
    paste(input$appts_window[1], "to", input$appts_window[2])
  )

  output$table <- renderTable(
    input$appts_data
  )
}
shinyApp(ui, server)
}

}
\seealso{
\code{\link[linevis]{linevis}}.
}
