% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_experiment.R
\name{create_experiment}
\alias{create_experiment}
\title{Create NetLogo BehaviorSpace experiment}
\usage{
create_experiment(
  name = "",
  repetitions = 1,
  sequential_run_order = TRUE,
  run_metrics_every_step = FALSE,
  time_limit = 1,
  pre_experiment = NULL,
  setup = "setup",
  go = "go",
  post_run = NULL,
  post_experiment = NULL,
  exit_condition = NULL,
  run_metrics_condition = NULL,
  metrics = "count turtles",
  constants = NULL,
  sub_experiments = NULL,
  file = tempfile(pattern = "experiment-", fileext = ".xml")
)
}
\arguments{
\item{name}{(optional) A \code{\link[base:character]{character}} string specifying
the name of the experiment (default: \code{""}).}

\item{repetitions}{(optional) An integer number specifying the number of
times to run the experiment (default: \code{1}).}

\item{sequential_run_order}{(optional) A \code{\link[base:logical]{logical}} flag
indicating whether to run the experiments in sequential order
(default: \code{TRUE}).}

\item{run_metrics_every_step}{(optional) A \code{\link[base:logical]{logical}} flag
indicating whether to record metrics at every step (default: \code{FALSE}).}

\item{time_limit}{(optional) An integer number specifying the maximum number
of steps to run for each repetition. Set to \code{0} or \code{NULL} to have no time
limit (default: \code{1}).}

\item{pre_experiment}{(optional) A \code{\link[base:character]{character}} vector
specifying the NetLogo command(s) to run before the experiment starts
(default: \code{NULL}).}

\item{setup}{(optional) A \code{\link[base:character]{character}} vector specifying
the NetLogo command(s) to set up the model (default: \code{'setup'}).}

\item{go}{(optional) A \code{\link[base:character]{character}} vector specifying the
NetLogo command(s) to run the model (default: \code{'go'}).}

\item{post_run}{(optional) A \code{\link[base:character]{character}} vector
specifying the NetLogo command(s) to run after each run (default: \code{NULL}).}

\item{post_experiment}{(optional) A \code{\link[base:character]{character}} vector
specifying the NetLogo command(s) to run after the experiment ends
(default: \code{NULL}).}

\item{exit_condition}{(optional) A \code{\link[base:character]{character}} vector
specifying the NetLogo command that defines the exit condition for the
experiment (default: \code{NULL}).}

\item{run_metrics_condition}{(optional) A \code{\link[base:character]{character}}
vector specifying the NetLogo command that defines the condition to record
metrics (default: \code{NULL}).}

\item{metrics}{A \code{\link[base:character]{character}} vector specifying the
NetLogo commands to record as metrics
(default: \code{'count turtles'}).}

\item{constants}{(optional) A named \code{\link[base:list]{list}} specifying the
parameters for the experiment. Each element can be either a scalar,
vector (for fixed/enumerated values), or a \code{\link[base:list]{list}} with
\code{first}, \code{step}, and \code{last} elements (for stepped/varying values). See the
\emph{Details} and \emph{Examples} sections to learn more (default: \code{NULL}).}

\item{sub_experiments}{(optional) A \code{\link[base:list]{list}} where each element
is also a \code{\link[base:list]{list}} specifying the constants for a
sub-experiment. Each sub-experiment uses the same structure as the
\code{constants} argument. See the \code{constants} argument documentation for
details on how to specify parameter values (default: \code{NULL}).}

\item{file}{(optional) A \code{\link[base:character]{character}} string specifying
the path to save the created \href{https://en.wikipedia.org/wiki/XML}{XML} file
(default: \code{tempfile(pattern = "experiment-", fileext = ".xml")}).}
}
\value{
A \code{\link[base:character]{character}} string with the path to the
created \href{https://en.wikipedia.org/wiki/XML}{XML} file.
}
\description{
\code{create_experiment()} creates a NetLogo
\href{https://docs.netlogo.org/behaviorspace.html}{BehaviorSpace} experiment
\href{https://en.wikipedia.org/wiki/XML}{XML} file
that can be used to run headless experiments with the
\code{\link[=run_experiment]{run_experiment()}} function.

For complete guidance on setting up and running experiments in NetLogo,
please refer to the
\href{https://docs.netlogo.org/behaviorspace.html#creating-an-experiment-setup}{BehaviorSpace Guide}.
}
\details{
\subsection{Enclosing}{

Since NetLogo only accepts double quotes for strings inside commands, we
recommend always using single quotes when writing NetLogo commands in R
to avoid mistakes. For example, to run the \verb{[1 "a" true]} command,
use \code{'[1 "a" true]'}, not \verb{"[1 \\"a\\" true]"}.
}

\subsection{Multiple Commands}{

Some arguments accept multiple NetLogo commands to be run in sequence. In
such cases, you can provide a \code{\link[base:character]{character}} vector with
each command as a separate element.

For example, to run two commands in sequence for the \code{go} argument,
you can provide:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{go = c("command-1", "command-2")
}\if{html}{\out{</div>}}
}

\subsection{\code{constants} Argument}{

The \code{constants} argument allows you to specify the parameters to vary in the
experiment. It should be a named \code{\link[base:list]{list}} where each name
corresponds to a NetLogo global variable. The value for each name can be
either:
\itemize{
\item A scalar or vector (for enumerated values). For example, to set the
variable \code{initial-number-of-turtles} to \code{10}, you would use
\code{list("initial-number-of-turtles" = 10)}.
\item A \code{\link[base:list]{list}} with \code{first}, \code{step}, and \code{last} elements (for
stepped values). For example, to vary the variable
\code{initial-number-of-turtles} from \code{10} to \code{50} in steps of \code{10}, you would
use
\code{list("initial-number-of-turtles" = list(first = 10, step = 10, last = 50))}.
}

When passing values to constants, \code{\link[base:character]{character}}
strings should be passed as is, without adding quotes to them. For example,
to set the variable \code{pathway} to \code{"SSP-585"}, you should use
\code{list("pathway" = "SSP-585")}, not \code{list("pathway" = '"SSP-585"')}.
}
}
\examples{
# The examples below reproduce experiments from the NetLogo Models Library.
# Try exporting these experiments from NetLogo and compare the XML files.

## Examples from the Wolf Sheep Predation Model (Sample Models) ----

### BehaviorSpace Combinatorial

setup_file <- create_experiment(
  name = "BehaviorSpace Combinatorial",
  repetitions = 1,
  sequential_run_order = TRUE,
  run_metrics_every_step = FALSE,
  time_limit = 1500,
  setup = 'setup',
  go = 'go',
  post_run = 'wait .5',
  run_metrics_condition = 'ticks mod 10 = 0',
  metrics = c(
    'count sheep',
    'count wolves',
    'count grass'
  ),
  constants = list(
    "model-version" = "sheep-wolves-grass",
    "wolf-reproduce" = c(3, 5, 10, 15),
    "wolf-gain-from-food" = c(10, 15, 30, 40)
  )
)

setup_file

setup_file |> inspect_experiment()

### Behaviorspace Run 3 Experiments

setup_file <- create_experiment(
  name = "Behaviorspace Run 3 Experiments",
  repetitions = 1,
  sequential_run_order = TRUE,
  run_metrics_every_step = FALSE,
  time_limit = 1500,
  setup = c(
    'setup',
    paste0(
      'print (word "sheep-reproduce: " sheep-reproduce ", wolf-reproduce: ',
      '" wolf-reproduce)'
    ),
    paste0(
      'print (word "sheep-gain-from-food: " sheep-gain-from-food ", ',
      'wolf-gain-from-food: " wolf-gain-from-food)'
    )
  ),
  go = 'go',
  post_run = c(
    'print (word "sheep: " count sheep ", wolves: " count wolves)',
    'print ""',
    'wait 1'
  ),
  run_metrics_condition = 'ticks mod 10 = 0',
  metrics = c(
    'count sheep',
    'count wolves',
    'count grass'
  ),
  constants = list(
    "model-version" = "sheep-wolves-grass"
  ),
  sub_experiments = list(
    list(
      "sheep-reproduce" = 1,
      "sheep-gain-from-food" = 1,
      "wolf-reproduce" = 2,
      "wolf-gain-from-food" = 10
    ),
    list(
      "sheep-reproduce" = 6,
      "sheep-gain-from-food" = 8,
      "wolf-reproduce" = 5,
      "wolf-gain-from-food" = 20
    ),
    list(
      "sheep-reproduce" = 20,
      "sheep-gain-from-food" = 15,
      "wolf-reproduce" = 15,
      "wolf-gain-from-food" = 30
    )
  )
)

setup_file

setup_file |> inspect_experiment()

### BehaviorSpace Run 3 Variable Values Per Experiments

setup_file <- create_experiment(
  name = "BehaviorSpace Run 3 Variable Values Per Experiments",
  repetitions = 1,
  sequential_run_order = TRUE,
  run_metrics_every_step = FALSE,
  time_limit = 1500,
  setup = c(
    'setup',
    paste0(
      'print (word "sheep-reproduce: " sheep-reproduce ", ',
      'wolf-reproduce: " wolf-reproduce)'
    ),
    paste0(
      'print (word "sheep-gain-from-food: " sheep-gain-from-food ", ',
      'wolf-gain-from-food: " wolf-gain-from-food)'
    )
  ),
  go = 'go',
  post_run = c(
    'print (word "sheep: " count sheep ", wolves: " count wolves)',
    'print ""',
    'wait 1'
  ),
  run_metrics_condition = 'ticks mod 10 = 0',
  metrics = c(
    'count sheep',
    'count wolves',
    'count grass'
  ),
  constants = list(
    "model-version" = "sheep-wolves-grass",
    "sheep-reproduce" = 4,
    "wolf-reproduce" = 2,
    "sheep-gain-from-food" = 4,
    "wolf-gain-from-food" = 20
  ),
  sub_experiments = list(
    list(
      "sheep-reproduce" = c(1, 6, 20)
    ),
    list(
      "wolf-reproduce" = c(2, 7, 15)
    ),
    list(
      "sheep-gain-from-food" = c(1, 8, 15)
    ),
    list(
      "wolf-gain-from-food" = c(10, 20, 30)
    )
  )
)

setup_file

setup_file |> inspect_experiment()

## Examples from the Spread of Disease Model (IABM Textbook) ----

### Population Density

setup_file <- create_experiment(
  name = "Population Density",
  repetitions = 10,
  sequential_run_order = TRUE,
  run_metrics_every_step = FALSE,
  time_limit = NULL,
  setup = 'setup',
  go = 'go',
  metrics = 'ticks',
  constants = list(
    "variant" = "mobile",
    "connections-per-node" = 4.1,
    "num-people" = list(
      first = 50,
      step = 50,
      last = 200
    ),
    "num-infected" = 1,
    "disease-decay" = 0
  )
)

setup_file

setup_file |> inspect_experiment()

### Degree

setup_file <- create_experiment(
  name = "Degree",
  repetitions = 10,
  sequential_run_order = TRUE,
  run_metrics_every_step = FALSE,
  time_limit = 50,
  setup = 'setup',
  go = 'go',
  metrics = 'count turtles with [infected?]',
  constants = list(
    "num-people" = 200,
    "connections-per-node" = list(
      first = 0.5,
      step = 0.5,
      last = 4
    ),
    "disease-decay" = 10,
    "variant" = "network",
    "num-infected" = 1
  )
)

setup_file

setup_file |> inspect_experiment()

### Environmental

setup_file <- create_experiment(
  name = "Environmental",
  repetitions = 10,
  sequential_run_order = TRUE,
  run_metrics_every_step = FALSE,
  time_limit = NULL,
  setup = 'setup',
  go = 'go',
  metrics = 'ticks',
  constants = list(
    "num-people" = 200,
    "connections-per-node" = 4,
    "disease-decay" = list(
      first = 0,
      step = 1,
      last = 10
    ),
    "variant" = "environmental",
    "num-infected" = 1
  )
)

setup_file

setup_file |> inspect_experiment()
}
\seealso{
Other BehaviorSpace functions: 
\code{\link{inspect_experiment}()},
\code{\link{read_experiment}()},
\code{\link{run_experiment}()}
}
\concept{BehaviorSpace functions}
