% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_choro.R
\name{mf_choro}
\alias{mf_choro}
\title{Plot a choropleth map}
\usage{
mf_choro(
  x,
  var,
  pal,
  alpha = NULL,
  rev = FALSE,
  breaks = "quantile",
  nbreaks,
  border,
  pch = 21,
  cex = 2,
  lwd = 0.7,
  col_na = "white",
  cex_na = 1,
  pch_na = 4,
  leg_pos = mf_get_leg_pos(x),
  leg_title = var,
  leg_title_cex = 0.8,
  leg_val_cex = 0.6,
  leg_val_rnd = 2,
  leg_val_dec = ".",
  leg_val_big = "",
  leg_no_data = "No data",
  leg_frame = FALSE,
  leg_horiz = FALSE,
  leg_adj = c(0, 0),
  leg_size = 1,
  leg_box_border,
  leg_box_cex = c(1, 1),
  leg_fg,
  leg_bg,
  leg_frame_border,
  add = FALSE
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{pal}{a set of colors or a palette name (from \link{hcl.colors})}

\item{alpha}{opacity, in the range [0,1]}

\item{rev}{if \code{pal} is a \link{hcl.colors} palette name, whether the ordering of the colors should be reversed (TRUE) or not (FALSE)}

\item{breaks}{either a numeric vector with the actual breaks, or a classification method name (see \link{mf_get_breaks} and Details)}

\item{nbreaks}{number of classes}

\item{border}{border color}

\item{pch}{pch type of pch if x is a POINT layer}

\item{cex}{cex cex of the symbols if x is a POINT layer}

\item{lwd}{border width}

\item{col_na}{color for missing values}

\item{cex_na}{cex for NA values if x is a POINT layer}

\item{pch_na}{pch for NA values if x is a POINT layer}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos = NA then the legend is not plotted. If leg_pos = 'interactive' click onthe map to choose the legend position.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_val_dec}{decimal separator}

\item{leg_val_big}{thousands separator}

\item{leg_no_data}{label for missing values}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{leg_horiz}{display the legend horizontally (for proportional symbols and choropleth types)}

\item{leg_adj}{adjust the postion of the legend in x and y directions}

\item{leg_size}{size of the legend; 2 means two times bigger}

\item{leg_box_border}{border color of legend boxes}

\item{leg_box_cex}{width and height size expansion of boxes}

\item{leg_fg}{color of the legend foreground}

\item{leg_bg}{color of the legend backgournd}

\item{leg_frame_border}{border color of the legend frame}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
x is (invisibly) returned.
}
\description{
Plot choropleth map.
}
\details{
Breaks defined by a numeric vector or a classification method are
left-closed: breaks defined by \code{c(2, 5, 10, 15, 20)}
will be mapped as [2 - 5[, [5 - 10[, [10 - 15[, [15 - 20].
The "jenks" method is an exception and has to be right-closed.
Jenks breaks computed as \code{c(2, 5, 10, 15, 20)}
will be mapped as [2 - 5], ]5 - 10], ]10 - 15], ]15 - 20].
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq, var = "MED", type = "choro")

mtq[6, "MED"] <- NA
mf_map(
  x = mtq, var = "MED", type = "choro",
  col_na = "grey", pal = "Cividis",
  breaks = "quantile", nbreaks = 4, border = "white",
  lwd = .5, leg_pos = "topleft",
  leg_title = "Median Income", leg_title_cex = 1.1,
  leg_val_cex = 1, leg_val_rnd = -2, leg_no_data = "No data",
  leg_frame = TRUE
)
}
\keyword{internal}
