% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov_mix_utils.R
\name{get_prior}
\alias{get_prior}
\title{Get component priors from MarkovFit object}
\usage{
get_prior(object, check = TRUE)
}
\arguments{
\item{object}{\code{\link{MarkovMix}} object.}

\item{check}{Logical (1L) indicating whether to check \code{object}
at the beginning.}
}
\value{
A numeric vector indicates component priors.
}
\description{
\code{get_prior} gets component priors from \code{\link{MarkovMix}} object,
normalized to sum up to 1.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\examples{
# Load example MarkovMix object
data("markov_mix_ex")

# Derive transition pattern soft counts
get_counts(object = markov_mix_ex)

# Derive the order of Markov chains
get_order(object = markov_mix_ex)

# Derive the states of Markov chains
get_states(object = markov_mix_ex)

# Derive state transition patterns
get_states_mat(markov_mix_ex)

# Derive probability matrices
get_prob(markov_mix_ex)

# Derive component priors
get_prior(markov_mix_ex)

# Combine state transition patterns and their probabilities
cbind(
  as.data.frame(get_states_mat(markov_mix_ex)),
  as.data.frame(get_prob(markov_mix_ex))
)

# Extract 1 or more components
markov_mix_ex[2L]
markov_mix_ex[c(1L, 3L)]

# Replace 1 or more components
nrow_value <- length(get_states(object = markov_mix_ex, check = FALSE))^
  (get_order(object = markov_mix_ex, check = FALSE) + 1L)
markov_mix_ex2 <- markov_mix_ex
markov_mix_ex2[2L] <- runif(nrow_value)
print(markov_mix_ex2)
markov_mix_ex3 <- markov_mix_ex
markov_mix_ex3[c(1L, 3L)] <- matrix(runif(nrow_value * 2L), ncol = 2L)
print(markov_mix_ex3)
}
\seealso{
Other MarkovMix utilities: 
\code{\link{Extract.MarkovMix}},
\code{\link{get_counts}()},
\code{\link{get_order}()},
\code{\link{get_prob}()},
\code{\link{get_states_mat}()},
\code{\link{get_states}()},
\code{\link{restate}()}
}
\author{
Xiurui Zhu
}
\concept{MarkovMix utilities}
