% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_S3_methods.R
\name{coef.mcglm}
\alias{coef.mcglm}
\title{Model Coefficients}
\usage{
\method{coef}{mcglm}(
  object,
  std.error = FALSE,
  response = c(NA, 1:length(object$beta_names)),
  type = c("beta", "tau", "power", "correlation"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{mcglm}.}

\item{std.error}{Logical indicating whether standard errors should be returned
alongside the parameter estimates. Default is \code{FALSE}.}

\item{response}{Integer vector indicating for which response variables the
coefficients should be returned. If \code{NA}, coefficients for
all response variables are returned.}

\item{type}{Character vector specifying which type of coefficients should be
returned. Possible values are \code{"beta"}, \code{"tau"},
\code{"power"} and \code{"correlation"}.}

\item{...}{Additional arguments. Currently ignored and included for
compatibility with the generic \code{\link[stats]{coef}} function.}
}
\value{
A \code{data.frame} with one row per parameter, containing:
\itemize{
  \item \code{Estimates}: parameter estimates;
  \item \code{Std.error}: standard errors (if requested);
  \item \code{Parameters}: parameter names;
  \item \code{Type}: parameter type;
  \item \code{Response}: response variable index.
}
}
\description{
Extract regression, dispersion and correlation parameter estimates
from objects of class \code{mcglm}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
