% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphql-introspection.R
\name{meetupr_schema}
\alias{meetupr_schema}
\title{Introspect the Meetup GraphQL API schema}
\usage{
meetupr_schema(asis = FALSE)
}
\arguments{
\item{asis}{Logical; if TRUE, returns the raw response from the API as JSON.
If FALSE (default), returns the parsed schema object.}
}
\value{
If \code{asis} is FALSE (default), the parsed schema object with nested
lists containing query types, mutation types, and type definitions. If
\code{asis} is TRUE, a JSON string representation of the schema.
}
\description{
This function performs an introspection query on the Meetup GraphQL API to
retrieve the full schema details, including available query types, mutation
types, and type definitions.
}
\examples{
\dontshow{
vcr::insert_example_cassette("meetupr_schema", package = "meetupr")
meetupr:::mock_if_no_auth()
}
# Get the full schema
schema <- meetupr_schema()

# Explore what's available
names(schema)

# Get as JSON for external tools
schema_json <- meetupr_schema(asis = TRUE)
\dontshow{
vcr::eject_cassette()
}

}
