% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_minesweeper_gif.R
\name{save_minesweeper_gif}
\alias{save_minesweeper_gif}
\title{Save a Minesweeper Recording to GIF}
\usage{
save_minesweeper_gif(
  recording,
  gif_file = "animation.gif",
  width = 800,
  height = 600,
  delay = 1,
  loop = TRUE,
  progress = TRUE,
  ...
)
}
\arguments{
\item{recording}{object of class "minesweeper_recording" returned by
\code{\link[=play_minesweeper]{play_minesweeper()}}}

\item{gif_file}{output gif file}

\item{width}{gif width in pixels}

\item{height}{gif height in pixel}

\item{delay}{time to show each image in seconds}

\item{loop}{if the gif should be repeated. Set to FALSE to only play
once, or a number to indicate how many times to repeat after the first.}

\item{progress}{print some verbose status output}

\item{...}{other graphical parameters passed to \link{png}}
}
\value{
The file path of the GIF file.
}
\description{
Save a recorded game of minesweeper to a GIF file.
}
\details{
Reduce the \code{delay} for greater temporal resolution.
}
\examples{
\dontshow{if (.Platform$OS.type == "unix" && interactive() && requireNamespace("gifski", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
x11() # Unix-specific example
recording <- play_minesweeper()
save_minesweeper_gif(recording)
dev.off()
\dontshow{\}) # examplesIf}
}
