% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnCVR_wrappers.R
\name{lnCVR_main}
\alias{lnCVR_main}
\title{Main Effect: Log Coefficient Of Variation Ration}
\usage{
lnCVR_main(
  data,
  col_names = c("yi", "vi"),
  append = TRUE,
  Ctrl_mean,
  Ctrl_sd,
  Ctrl_n,
  A_mean,
  A_sd,
  A_n,
  B_mean,
  B_sd,
  B_n,
  AB_mean,
  AB_sd,
  AB_n
)
}
\arguments{
\item{data}{Data frame containing the variables used.}

\item{col_names}{Vector of two strings to name the output columns for the effect size and its sampling variance. Default is 'yi' and 'vi'.}

\item{append}{Logical. Append the results to \code{data}. Default is TRUE}

\item{Ctrl_mean}{Mean outcome from the Control treatment}

\item{Ctrl_sd}{Standard deviation from the control treatment}

\item{Ctrl_n}{Sample size from the control treatment}

\item{A_mean}{Mean outcome from the treatment}

\item{A_sd}{Standard deviation from the treatment}

\item{A_n}{Sample size from the treatment}

\item{B_mean}{Mean outcome from the B treatment}

\item{B_sd}{Standard deviation from the B treatment}

\item{B_n}{Sample size from the B treatment}

\item{AB_mean}{Mean outcome from the interaction AxB treatment}

\item{AB_sd}{Standard deviation from the interaction AxB treatment}

\item{AB_n}{Sample size from the interaction AxB treatment}
}
\value{
A data frame containing the effect sizes and their sampling variance.
By default, the columns are named \code{yi} (effect size) and \code{vi} (sampling variance).
If \code{append = TRUE}, the results are appended to the input \code{data}; otherwise, only the computed effect size columns are returned.
}
\description{
Computes the main effect of Factor A across levels of Factor B
in factorial experiments on the coefficient of variation.
}
\details{
See the package vignette for a detailed description of the formula.
}
\examples{
data <- data.frame(
  study_id = 1:2,
  control_mean = c(14.2, 16.8), control_sd = c(2.8, 3.1), control_n = c(16, 14),
  irrigation_mean = c(19.5, 22.1), irrigation_sd = c(5.2, 5.8), irrigation_n = c(15, 16),
  co2_mean = c(16.8, 19.4), co2_sd = c(3.1, 3.6), co2_n = c(17, 13),
  irrigation_co2_mean = c(24.3, 27.9), irrigation_co2_sd = c(6.8, 7.4), irrigation_co2_n = c(14, 15)
)

result <- lnCVR_main(
  data = data,
  Ctrl_mean = "control_mean", Ctrl_sd = "control_sd", Ctrl_n = "control_n",
  A_mean = "irrigation_mean", A_sd = "irrigation_sd", A_n = "irrigation_n",
  B_mean = "co2_mean", B_sd = "co2_sd", B_n = "co2_n", 
  AB_mean = "irrigation_co2_mean", AB_sd = "irrigation_co2_sd", AB_n = "irrigation_co2_n"
)

}
\author{
Facundo Decunta - fdecunta@agro.uba.ar
}
