% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_unified.R
\name{mispitools_app}
\alias{mispitools_app}
\title{Comprehensive Shiny App for Missing Person Identification}
\usage{
mispitools_app()
}
\value{
A Shiny app object. When run interactively, launches a multi-tab
web interface with:
\itemize{
\item \strong{Welcome}: Introduction to LR concepts
\item \strong{Individual Evidence}: Calculate LR for each evidence type
\item \strong{CPT Analysis}: Visualize conditional probability tables
\item \strong{Distribution}: Simulate and visualize LR distributions
\item \strong{Combine Evidence}: Combine multiple evidence types
\item \strong{Decision Analysis}: Threshold selection and error metrics
\item \strong{Tutorial}: Step-by-step educational content
}
}
\description{
Launches a comprehensive interactive Shiny application for calculating
likelihood ratios (LRs) from non-genetic evidence in missing person cases.
This unified app integrates all evidence types (sex, age, hair color,
birthdate) with tutorials, visualizations, and decision analysis tools.
}
\details{
This app provides a complete workflow for forensic identification using
non-genetic evidence. It implements the Bayesian framework where:
\itemize{
\item H1: The unidentified person IS the missing person
\item H2: The unidentified person is NOT the missing person
\item LR = P(Evidence | H1) / P(Evidence | H2)
}

Evidence types supported:
\itemize{
\item Biological sex (male/female)
\item Age (within expected range)
\item Hair color (5 categories)
\item Birth date (discrepancy analysis)
}
}
\examples{
if (interactive()) {
  mispitools_app()
}
}
\references{
Marsico FL, Caridi I (2023). "Incorporating non-genetic evidence in large
scale missing person searches: A general approach beyond filtering."
\emph{Forensic Science International: Genetics}, 66, 102891.
\doi{10.1016/j.fsigen.2023.102891}

Marsico FL, Vigeland MD, et al. (2021). "Making decisions in missing person
identification cases with low statistical power."
\emph{Forensic Science International: Genetics}, 52, 102519.
\doi{10.1016/j.fsigen.2021.102519}
}
\seealso{
\code{\link{lr_sex}}, \code{\link{lr_age}}, \code{\link{lr_hair_color}},
\code{\link{lr_birthdate}} for individual LR calculations,
\code{\link{lr_combine}} for combining evidence,
\code{\link{decision_threshold}}, \code{\link{threshold_rates}} for
decision analysis.
}
