\name{mlt-package}
\docType{package}
\alias{mlt-package}
\title{General Information on the \pkg{mlt} Package}
\description{
  The \pkg{mlt} package implements maximum likelihood estimation in 
  conditional transformation models as introduced by Hothorn et al. (2020),
  Klein et al. (2022), and Siegfried et al. (2023).

  An introduction to the package is available in the \code{mlt} package
  vignette from package \code{mlt.docreg} (Hothorn, 2020).

  Novice users might find the high(er) level interfaces offered by package
  \pkg{tram} more convenient.

}
\references{

  Torsten Hothorn, Lisa Moest, Peter Buehlmann (2018), Most Likely
  Transformations, \emph{Scandinavian Journal of Statistics}, \bold{45}(1),
  110--134, \doi{10.1111/sjos.12291}.

  Torsten Hothorn (2020), Most Likely Transformations: The mlt Package,
  \emph{Journal of Statistical Software}, \bold{92}(1), 1--68,
  \doi{10.18637/jss.v092.i01}

  Nadja Klein, Torsten Hothorn, Luisa Barbanti, Thomas Kneib (2022),
  Multivariate Conditional Transformation Models. \emph{Scandinavian Journal
  of Statistics}, \bold{49}, 116--142, \doi{10.1111/sjos.12501}.

  Sandra Siegfried, Lucas Kook, Torsten Hothorn (2023), 
  Distribution-Free Location-Scale Regression, \emph{The American Statistician},
  \bold{77}(4), 345--356, \doi{10.1080/00031305.2023.2203177}.

  Torsten Hothorn (2024), On Nonparanormal Likelihoods. \doi{10.48550/arXiv.2408.17346}.

}
\author{
  This package is authored by Torsten Hothorn <Torsten.Hothorn@R-project.org>.
}
\keyword{package}
