% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wild_boot_lm.R
\name{wild_boot_lm}
\alias{wild_boot_lm}
\title{Wild Bootstrap for Linear Model Coefficients}
\usage{
wild_boot_lm(fit, R = 2000, type = c("rademacher", "mammen"))
}
\arguments{
\item{fit}{an object of class 'lm' from \code{\link[stats]{lm}}.
Should be fitted linear regression model. Heteroscedasticity is allowed and
expected - this method is specifically designed to handle non-constant variance
in residuals. Model should have at least 1 predictor.}

\item{R}{integer number of bootstrap replicates (default 2000).
Larger values (5000-10000) recommended for confidence intervals in publications.
Must be >= 1 and a whole number.}

\item{type}{character string specifying weight distribution scheme.
Options: "rademacher" (default, faster, robust) generates weights as +1/-1
with equal probability. "mammen" (asymptotically optimal) uses empirically
calibrated Mammen distribution with golden ratio. Choice has minimal practical
impact on results.}
}
\value{
A list with two elements:
  \item{coef}{numeric vector of original fitted model coefficients,
    including intercept if present. Names preserved from original model.}
  \item{boot}{numeric matrix of dimensions (p x R) where p is number of
    coefficients. Each column contains one bootstrap replicate of coefficients.
    Row names are coefficient names; column names are bootstrap iteration numbers.}
}
\description{
Performs wild bootstrap resampling for linear regression models to handle heteroscedasticity.
Supports Rademacher and Mammen weight schemes.
}
\details{
The wild bootstrap works by resampling residuals with random signs/weights while keeping
predictors fixed. This is particularly useful for heteroscedastic data.
}
\examples{
set.seed(42)
x <- rnorm(50)
y <- 2 + 1.5 * x + rnorm(50, sd = abs(x))  # heteroscedastic
fit <- lm(y ~ x)
result <- wild_boot_lm(fit, R = 500, type = "rademacher")
head(result$boot, 3)

}
