% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/K_sim.R
\name{grf}
\alias{grf}
\title{Generate a Gaussian Random Field}
\usage{
grf(x, range, fun = "scale", ...)
}
\arguments{
\item{x}{A template raster of class \code{\link[terra:SpatRaster-class]{SpatRaster}} (from the \pkg{terra} package).}

\item{range}{Numeric. The range parameter of the variogram model (in spatial units of \code{x} raster).}

\item{fun}{A function to apply to the generated values (default is \code{\link[base:scale]{scale}} to standardize the GRF).}

\item{...}{Additional arguments passed to the function specified in \code{fun}.}
}
\value{
A \code{\link[terra:SpatRaster-class]{SpatRaster}} object containing the generated Gaussian random field.
}
\description{
Generates a Gaussian random field (GRF) based on the Matern model of spatial autocorrelation.
}
\examples{
library(terra)
r <- rast(nrows = 100, ncols = 100, xmin = 0, xmax = 100, ymin = 0, ymax = 100)
grf_field <- grf(r, range = 30)
plot(grf_field)


}
