% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialise_com.R
\name{initialise_com}
\alias{initialise_com}
\title{Initialise Community Simulation Data}
\usage{
initialise_com(
  n1_map = NULL,
  K_map,
  r,
  a,
  dlist = NULL,
  invasion = NULL,
  use_names_K_map = TRUE,
  ...
)
}
\arguments{
\item{n1_map}{A \code{\link[terra:SpatRaster-class]{SpatRaster}} with one layer per species representing the initial abundance.  If \code{NULL} (default), random initial values will be generated
from a Poisson distribution using \code{K_map}.}

\item{K_map}{A \code{\link[terra:SpatRaster-class]{SpatRaster}} with one layer per species representing carrying capacities.}

\item{r}{A numeric vector of intrinsic growth rates. It can be a single-element vector (if all species have the same intrinsic growth rate) or a vector of length equal to the number of species in the community.}

\item{a}{A square numeric matrix representing interaction coefficients between species. Each element \code{a_ij} is the per-capita interaction strength of species \code{j} on species \code{i}. It expresses the change in carrying capacity of species \code{i} by a single individual of species \code{j}. The diagonal must be \code{NA} and the matrix must be a square matrix of order equal to the number of species. It does not have to be symmetric.}

\item{dlist}{Optional. A list; target cells at a specified distance calculated
for every cell within the study area.}

\item{invasion}{Optional. A named list of specifying invasion configuration (can be prepared using \code{\link{initialise_inv}}). Must contain:
\describe{
\item{invaders}{Integer vector of invading species indices.}
\item{propagule_size}{Number of individuals introduced per invasion event.}
\item{invasion_times}{Matrix of invasion times, with one row per invader.}
}}

\item{use_names_K_map}{Logical. If \code{TRUE}, the layer names of \code{K_map} are
used as species names. If \code{FALSE}, species are numbered sequentially
(\code{1:number_of_species}). Defaults to \code{TRUE}.}

\item{...}{Additional named arguments passed to \code{\link[rangr:initialise]{initialise()}}. Each must be either length 1 or equal to the number of species.
\describe{
\item{kernel_args}{Optional. A list of lists, each containing named arguments for the corresponding
species' kernel function. Must be the same length as number of species.}
}}
}
\value{
A list of class \code{sim_com_data} containing:
\describe{
\item{spec_data}{A list of \code{sim_data} objects (one per species) returned by \code{\link[rangr:initialise]{initialise()}}.}
\item{nspec}{The number of species.}
\item{a}{The interaction matrix.}
\item{r}{Intrinsic growth rate(s).}
\item{n1_map}{Initial abundance maps (wrapped \code{SpatRaster}).}
\item{K_map}{Carrying capacity maps (wrapped \code{SpatRaster}).}
\item{max_dist}{The maximum dispersal distance across all species.}
\item{dlist}{A list; target cells at a specified distance calculated
for every cell within the study area.}
\item{invasion}{Invasion configuration (if any).}
\item{call}{The matched call.}
}
}
\description{
Prepares community-level input data for a spatial simulation.
This function builds on \code{\link[rangr:initialise]{rangr::initialise()}}
by organising inputs for multiple species and their interactions.
}
\examples{
\donttest{
library(terra)

# Read data from the mrangr package

## Input maps
K_map <- rast(system.file("input_maps/K_map_eg.tif", package = "mrangr"))
n1_map <- rast(system.file("input_maps/n1_map_eg.tif", package = "mrangr"))

## Interaction coefficients matrix
a <- a_eg

# Initialise simulation parameters
community_01 <-
  initialise_com(
  K_map = K_map,
  n1_map = n1_map,
  r = 1.1,
  a = a,
  rate = 0.002)

# With invaders
invasion <- initialise_inv(
  invaders = c(1, 3),
  invasion_times = c(2, 5))

community_02 <- initialise_com(
  K_map = K_map,
  r = 1.1,
  a = a,
  rate = 0.002,
  invasion = invasion)


# Custom kernel function
abs_rnorm <- function(n, mean, sd) {
  abs(rnorm(n, mean = mean, sd = sd))
}

community_03 <- initialise_com(
  K_map = K_map,
  n1_map = n1_map,
  r = c(1.1, 1.05, 1.2, 1),
  a = a,
  kernel_fun = c("rexp", "rexp", "abs_rnorm", "abs_rnorm"),
  kernel_args = list(
    list(rate = 0.002),
    list(rate = 0.001),
    list(mean = 0, sd = 1000),
    list(mean = 0, sd = 2000))
)
}

}
