% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_zero}
\alias{set_zero}
\title{Set Non-Missing Values to Zero}
\usage{
set_zero(x)
}
\arguments{
\item{x}{A vector or other object for which \code{is.na()} and subsetting with \verb{[]}
are defined (e.g., vector, data frame, SpatRaster).}
}
\value{
An object of the same type as \code{x} with all originally non-missing
elements replaced by zero.
}
\description{
This function takes an object and sets all non-missing
values to zero, while leaving missing values unchanged.
}
\examples{
# Example with a numeric vector
vec <- c(1, 2, NA, 4, NA, 5)
set_zero(vec)

}
